/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.codec.Codec;
import io.basc.framework.codec.DecodeException;
import io.basc.framework.codec.EncodeException;
import io.basc.framework.util.ArrayUtils;
import io.basc.framework.util.Assert;
import io.basc.framework.util.NumberReplacer;
import io.basc.framework.util.NumberUnit;
import io.basc.framework.util.NumberUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;

public final class MoneyFormat
implements Codec<BigDecimal, String> {
    public static final MoneyFormat CAPITALIZE = new MoneyFormat(NumberReplacer.CAPITALIZE);
    public static final MoneyFormat LOWERCASE = new MoneyFormat(NumberReplacer.LOWERCASE);
    private final Codec<BigDecimal, String> numberCodec;
    private final NumberUnit[] integerUnits;
    private final NumberUnit[] decimalUnits;

    public MoneyFormat(Codec<BigDecimal, String> numberCodec) {
        this(numberCodec, new NumberUnit[]{NumberUnit.MONEY_100000000, NumberUnit.MONEY_10000, NumberUnit.MONEY_1000, NumberUnit.MONEY_100, NumberUnit.MONEY_10, NumberUnit.MONEY}, new NumberUnit[]{NumberUnit.MONEY_01, NumberUnit.MONEY_001});
    }

    public MoneyFormat(Codec<BigDecimal, String> numberCodec, NumberUnit[] integerUnits, NumberUnit[] decimalUnits) {
        Assert.requiredArgument(numberCodec != null, "numberCodec");
        Assert.requiredArgument(integerUnits != null, "integerUnits");
        Assert.requiredArgument(decimalUnits != null, "decimalUnits");
        this.numberCodec = numberCodec;
        this.integerUnits = integerUnits;
        this.decimalUnits = decimalUnits;
    }

    public Codec<BigDecimal, String> getNumberCodec() {
        return this.numberCodec;
    }

    @Override
    public String encode(BigDecimal money) throws EncodeException {
        StringBuilder sb = new StringBuilder();
        BigDecimal number = money.abs();
        BigDecimal[] decimals = number.divideAndRemainder(BigDecimal.ONE);
        if (decimals[0].compareTo(BigDecimal.ZERO) == 0) {
            sb.append((String)this.numberCodec.encode(BigDecimal.ZERO));
            sb.append("\u5143");
        } else {
            NumberUtils.format(sb, decimals[0], this.numberCodec::encode, 0, this.integerUnits.length, this.integerUnits);
        }
        decimals[1] = decimals[1].setScale(2, RoundingMode.HALF_UP);
        if (decimals[1].compareTo(BigDecimal.ZERO) == 0) {
            sb.append("\u6574");
        } else {
            NumberUtils.format(sb, decimals[1], this.numberCodec::encode, 0, this.decimalUnits.length, this.decimalUnits);
        }
        return sb.toString();
    }

    @Override
    public BigDecimal decode(String money) throws DecodeException {
        int index = money.indexOf("\u6574");
        if (index == -1) {
            index = money.indexOf("\u5143");
            if (index == -1) {
                return NumberUtils.parse(money, this.numberCodec::decode, ArrayUtils.merge(this.integerUnits, this.decimalUnits));
            }
            return NumberUtils.parse(money.substring(0, index), this::decode, this.integerUnits).add(NumberUtils.parse(money.substring(index + 1), this::decode, this.decimalUnits));
        }
        return NumberUtils.parse(money.substring(0, index), this::decode, this.integerUnits);
    }

    @Override
    public String encode(long money) {
        return this.encode(new BigDecimal(money));
    }
}

