/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MultiIterator<E>
implements Iterator<E> {
    private final Iterator<Iterator<E>> iterators;
    private Iterator<E> valueIterator;

    @SafeVarargs
    public MultiIterator(Iterator<E> ... iterables) {
        this(Arrays.asList(iterables));
    }

    public MultiIterator(Iterable<Iterator<E>> iterables) {
        this.iterators = iterables.iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.valueIterator != null && this.valueIterator.hasNext()) {
            return true;
        }
        while (this.iterators != null && this.iterators.hasNext()) {
            this.valueIterator = this.iterators.next();
            if (this.valueIterator != null && this.valueIterator.hasNext()) {
                return true;
            }
            this.valueIterator = null;
        }
        return false;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.valueIterator.next();
    }
}

