/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.lang.ParameterException;
import io.basc.framework.util.Assert;
import io.basc.framework.util.ClassUtils;
import io.basc.framework.util.NumberUnit;
import io.basc.framework.util.Processor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;

public abstract class NumberUtils {
    public static Object converPrimitive(Number number, Class<?> targetClass) {
        Assert.notNull((Object)number, "Number must not be null");
        Assert.notNull(targetClass, "Target class must not be null");
        if (ClassUtils.isByte(targetClass)) {
            return number.byteValue();
        }
        if (ClassUtils.isShort(targetClass)) {
            return number.shortValue();
        }
        if (ClassUtils.isInt(targetClass)) {
            return number.intValue();
        }
        if (ClassUtils.isLong(targetClass)) {
            return number.longValue();
        }
        if (ClassUtils.isFloat(targetClass)) {
            return Float.valueOf(number.floatValue());
        }
        if (ClassUtils.isDouble(targetClass)) {
            return number.doubleValue();
        }
        if (ClassUtils.isBoolean(targetClass)) {
            return number.intValue() == 1;
        }
        if (ClassUtils.isChar(targetClass)) {
            return Character.valueOf((char)number.intValue());
        }
        throw new ParameterException(targetClass.getName() + "\u4e0d\u662f\u4e00\u4e2a\u57fa\u672c\u6570\u636e\u7c7b\u578b");
    }

    public static <T extends Number> T convertNumberToTargetClass(Number number, Class<T> targetClass) throws IllegalArgumentException {
        Assert.notNull((Object)number, "Number must not be null");
        Assert.notNull(targetClass, "Target class must not be null");
        if (targetClass.isInstance(number)) {
            return (T)number;
        }
        if (targetClass.equals(Byte.class)) {
            long value = number.longValue();
            if (value < -128L || value > 127L) {
                NumberUtils.raiseOverflowException(number, targetClass);
            }
            return (T)Byte.valueOf(number.byteValue());
        }
        if (targetClass.equals(Short.class)) {
            long value = number.longValue();
            if (value < -32768L || value > 32767L) {
                NumberUtils.raiseOverflowException(number, targetClass);
            }
            return (T)Short.valueOf(number.shortValue());
        }
        if (targetClass.equals(Integer.class)) {
            long value = number.longValue();
            if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
                NumberUtils.raiseOverflowException(number, targetClass);
            }
            return (T)Integer.valueOf(number.intValue());
        }
        if (targetClass.equals(Long.class)) {
            return (T)Long.valueOf(number.longValue());
        }
        if (targetClass.equals(BigInteger.class)) {
            if (number instanceof BigDecimal) {
                return (T)((BigDecimal)number).toBigInteger();
            }
            return (T)BigInteger.valueOf(number.longValue());
        }
        if (targetClass.equals(Float.class)) {
            return (T)Float.valueOf(number.floatValue());
        }
        if (targetClass.equals(Double.class)) {
            return (T)Double.valueOf(number.doubleValue());
        }
        if (targetClass.equals(BigDecimal.class)) {
            return (T)new BigDecimal(number.toString());
        }
        throw new IllegalArgumentException("Could not convert number [" + number + "] of type [" + number.getClass().getName() + "] to unknown target class [" + targetClass.getName() + "]");
    }

    private static void raiseOverflowException(Number number, Class targetClass) {
        throw new IllegalArgumentException("Could not convert number [" + number + "] of type [" + number.getClass().getName() + "] to target class [" + targetClass.getName() + "]: overflow");
    }

    public static <T extends Number> T parseNumber(String text, Class<T> targetClass) {
        Assert.notNull((Object)text, "Text must not be null");
        Assert.notNull(targetClass, "Target class must not be null");
        String trimmed = text.trim();
        if (targetClass.equals(Byte.class)) {
            return (T)(NumberUtils.isHexNumber(trimmed) ? Byte.decode(trimmed) : Byte.valueOf(trimmed));
        }
        if (targetClass.equals(Short.class)) {
            return (T)(NumberUtils.isHexNumber(trimmed) ? Short.decode(trimmed) : Short.valueOf(trimmed));
        }
        if (targetClass.equals(Integer.class)) {
            return (T)(NumberUtils.isHexNumber(trimmed) ? Integer.decode(trimmed) : Integer.valueOf(trimmed));
        }
        if (targetClass.equals(Long.class)) {
            return (T)(NumberUtils.isHexNumber(trimmed) ? Long.decode(trimmed) : Long.valueOf(trimmed));
        }
        if (targetClass.equals(BigInteger.class)) {
            return (T)(NumberUtils.isHexNumber(trimmed) ? NumberUtils.decodeBigInteger(trimmed) : new BigInteger(trimmed));
        }
        if (targetClass.equals(Float.class)) {
            return (T)Float.valueOf(trimmed);
        }
        if (targetClass.equals(Double.class)) {
            return (T)Double.valueOf(trimmed);
        }
        if (targetClass.equals(BigDecimal.class) || targetClass.equals(Number.class)) {
            return (T)new BigDecimal(trimmed);
        }
        throw new IllegalArgumentException("Cannot convert String [" + text + "] to target class [" + targetClass.getName() + "]");
    }

    public static boolean isNumber(Class<?> type) {
        return type == Long.TYPE || type == Integer.TYPE || type == Byte.TYPE || type == Short.TYPE || type == Float.TYPE || type == Double.TYPE || Number.class.isAssignableFrom(type);
    }

    public static boolean isInteger(Class<?> type) {
        return type == Long.TYPE || type == Integer.TYPE || type == Byte.TYPE || type == Short.TYPE || BigInteger.class.isAssignableFrom(type);
    }

    public static <T extends Number> T parseNumber(String text, Class<T> targetClass, NumberFormat numberFormat) {
        if (numberFormat != null) {
            Assert.notNull((Object)text, "Text must not be null");
            Assert.notNull(targetClass, "Target class must not be null");
            DecimalFormat decimalFormat = null;
            boolean resetBigDecimal = false;
            if (numberFormat instanceof DecimalFormat) {
                decimalFormat = (DecimalFormat)numberFormat;
                if (BigDecimal.class.equals(targetClass) && !decimalFormat.isParseBigDecimal()) {
                    decimalFormat.setParseBigDecimal(true);
                    resetBigDecimal = true;
                }
            }
            try {
                Number number = numberFormat.parse(text.trim());
                T t = NumberUtils.convertNumberToTargetClass(number, targetClass);
                return t;
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("Could not parse number: " + ex.getMessage());
            }
            finally {
                if (resetBigDecimal) {
                    decimalFormat.setParseBigDecimal(false);
                }
            }
        }
        return NumberUtils.parseNumber(text, targetClass);
    }

    private static boolean isHexNumber(String value) {
        int index = value.startsWith("-") ? 1 : 0;
        return value.startsWith("0x", index) || value.startsWith("0X", index) || value.startsWith("#", index);
    }

    private static BigInteger decodeBigInteger(String value) {
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (value.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (value.startsWith("0x", index) || value.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (value.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (value.startsWith("0", index) && value.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        BigInteger result = new BigInteger(value.substring(index), radix);
        return negative ? result.negate() : result;
    }

    public static boolean isInteger(BigDecimal number) {
        return number.signum() == 0 || number.scale() <= 0 || number.stripTrailingZeros().scale() <= 0;
    }

    public static BigDecimal stripTrailingZeros(BigDecimal number) {
        if (number.signum() == 0 || number.scale() <= 0) {
            return number;
        }
        BigDecimal target = number.stripTrailingZeros();
        if (target.scale() <= 0) {
            return number.setScale(0);
        }
        return number;
    }

    public static String format(BigDecimal number, NumberUnit ... units) {
        return NumberUtils.format(number, (BigDecimal e) -> NumberUtils.stripTrailingZeros(e).toPlainString(), units);
    }

    public static BigDecimal parse(String source, NumberUnit ... units) {
        return NumberUtils.parse(source, (String e) -> new BigDecimal((String)e), units);
    }

    public static <E extends Throwable> String format(BigDecimal number, Processor<BigDecimal, String, E> toString, NumberUnit ... units) throws E {
        Assert.requiredArgument(number != null, "number");
        Assert.requiredArgument(toString != null, "toString");
        if (units == null || units.length == 0 || number.compareTo(BigDecimal.ZERO) == 0) {
            return toString.process(number.abs());
        }
        StringBuilder sb = new StringBuilder();
        NumberUtils.format(sb, number.abs(), toString, 0, units.length, units);
        return sb.toString();
    }

    protected static <E extends Throwable> void format(StringBuilder sb, BigDecimal number, Processor<BigDecimal, String, E> toString, int startUnitsIndex, int endUnitsIndex, NumberUnit ... units) throws E {
        BigDecimal surplus = number;
        for (int i = startUnitsIndex; i < Math.min(endUnitsIndex, units.length); ++i) {
            boolean notNested;
            NumberUnit unit = units[i];
            if (unit.getRadix().compareTo(surplus) > 0) continue;
            BigDecimal[] decimals = surplus.divideAndRemainder(unit.getRadix());
            boolean last = true;
            for (NumberUnit u : units) {
                if (decimals[1].compareTo(u.getRadix()) < 0) continue;
                last = false;
                break;
            }
            if (last) {
                decimals[0] = surplus.divide(unit.getRadix());
                decimals[1] = BigDecimal.ZERO;
            }
            boolean bl = notNested = last || decimals[1].compareTo(BigDecimal.ZERO) == 0 || unit.getRadix().compareTo(BigDecimal.ONE) < 0;
            if (notNested) {
                sb.append(toString.process(decimals[0]));
            } else {
                NumberUtils.format(sb, decimals[0], toString, i, units.length - 1, units);
            }
            sb.append(unit.getName());
            if (!notNested && i < units.length - 1 && decimals[1].divideToIntegralValue(units[i + 1].getRadix()).compareTo(BigDecimal.ZERO) == 0) {
                sb.append(toString.process(BigDecimal.ZERO));
            }
            surplus = decimals[1];
        }
        if (surplus.compareTo(BigDecimal.ZERO) > 0) {
            sb.append(toString.process(surplus));
        }
    }

    public static <E extends Throwable> BigDecimal parse(String source, Processor<String, BigDecimal, E> converter, NumberUnit ... units) throws E {
        for (NumberUnit unit : units) {
            int index = source.indexOf(unit.getName());
            if (index == -1) continue;
            String left = source.substring(0, index);
            BigDecimal value = NumberUtils.parse(left, converter, units).multiply(unit.getRadix());
            if (index < source.length() - unit.getName().length()) {
                String right = source.substring(index + unit.getName().length());
                value = value.add(NumberUtils.parse(right, converter, units));
            }
            return value;
        }
        return converter.process(source);
    }

    public static String formatPrecision(double number, int len) {
        if (len < 0) {
            throw new IllegalStateException("len < 0");
        }
        if (len == 0) {
            return (long)number + "";
        }
        if (number == 0.0) {
            CharBuffer charBuffer = CharBuffer.allocate(len + 2);
            charBuffer.put('0');
            charBuffer.put('.');
            for (int i = 0; i < len; ++i) {
                charBuffer.put('0');
            }
            return new String(charBuffer.array());
        }
        CharBuffer charBuffer = CharBuffer.allocate(len + 3);
        charBuffer.put("#0.");
        for (int i = 0; i < len; ++i) {
            charBuffer.put("0");
        }
        return new DecimalFormat(new String(charBuffer.array())).format(number);
    }
}

