/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.Assert;
import io.basc.framework.util.Processor;
import java.util.Iterator;
import java.util.Objects;

public interface PredicateProcessor<T, E extends Throwable> {
    public boolean process(T var1) throws E;

    default public Processor<T, Boolean, E> toProcessor() {
        return s -> this.process(s);
    }

    default public PredicateProcessor<T, E> and(PredicateProcessor<? super T, ? extends E> other) {
        Objects.requireNonNull(other);
        return t -> this.process(t) && other.process(t);
    }

    default public PredicateProcessor<T, E> negate() {
        return t -> !this.process(t);
    }

    default public PredicateProcessor<T, E> or(PredicateProcessor<? super T, ? extends E> other) {
        Objects.requireNonNull(other);
        return t -> this.process(t) || other.process(t);
    }

    public static <T, X extends Throwable> PredicateProcessor<T, X> isEqual(Object targetRef) {
        return null == targetRef ? Objects::isNull : object -> targetRef.equals(object);
    }

    public static <S, X extends Throwable> boolean all(Iterator<? extends S> iterator, PredicateProcessor<? super S, ? extends X> processor) throws X {
        Assert.requiredArgument(processor != null, "processor");
        if (iterator == null || !iterator.hasNext()) {
            return true;
        }
        while (iterator.hasNext()) {
            if (processor.process(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static <S, X extends Throwable> boolean any(Iterator<? extends S> iterator, PredicateProcessor<? super S, ? extends X> processor) throws X {
        Assert.requiredArgument(processor != null, "processor");
        if (iterator == null || !iterator.hasNext()) {
            return true;
        }
        while (iterator.hasNext()) {
            if (!processor.process(iterator.next())) continue;
            return true;
        }
        return false;
    }
}

