/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.AbstractOptional;
import io.basc.framework.util.Assert;
import io.basc.framework.util.Bound;
import io.basc.framework.util.ObjectUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Function;

public final class Range<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Range<?> UNBOUNDED = Range.of(Bound.unbounded(), Bound.unbounded());
    private final Bound<T> lowerBound;
    private final Bound<T> upperBound;

    public Range(Bound<T> lowerBound, Bound<T> upperBound) {
        Assert.requiredArgument(lowerBound != null, "lowerBound");
        Assert.requiredArgument(upperBound != null, "upperBound");
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public <U, E> Range<U> convert(Function<? super T, ? extends U> converter) {
        return new Range<T>(this.lowerBound.convert(converter), this.upperBound.convert(converter));
    }

    public Bound<T> getLowerBound() {
        return this.lowerBound;
    }

    public Bound<T> getUpperBound() {
        return this.upperBound;
    }

    public static <T> Range<T> unbounded() {
        return UNBOUNDED;
    }

    public static <T> Range<T> closed(T from, T to) {
        return new Range<T>(Bound.inclusive(from), Bound.inclusive(to));
    }

    public static <T> Range<T> open(T from, T to) {
        return new Range<T>(Bound.exclusive(from), Bound.exclusive(to));
    }

    public static <T> Range<T> leftOpen(T from, T to) {
        return new Range<T>(Bound.exclusive(from), Bound.inclusive(to));
    }

    public static <T> Range<T> rightOpen(T from, T to) {
        return new Range<T>(Bound.inclusive(from), Bound.exclusive(to));
    }

    public static <T> Range<T> leftUnbounded(Bound<T> to) {
        return new Range(Bound.unbounded(), to);
    }

    public static <T> Range<T> rightUnbounded(Bound<T> from) {
        return new Range<T>(from, Bound.unbounded());
    }

    public static <T> RangeBuilder<T> from(Bound<T> lower) {
        Assert.notNull(lower, "Lower bound must not be null!");
        return new RangeBuilder<T>(lower);
    }

    public static <T> Range<T> of(Bound<T> lowerBound, Bound<T> upperBound) {
        return new Range<T>(lowerBound, upperBound);
    }

    public static <T> Range<T> just(T value) {
        return Range.closed(value, value);
    }

    public boolean contains(T value, Comparator<T> comparator) {
        Assert.notNull(value, "Reference value must not be null!");
        boolean greaterThanLowerBound = ((AbstractOptional)this.lowerBound.map(it -> this.lowerBound.isInclusive() ? comparator.compare(it, value) <= 0 : comparator.compare(it, value) < 0)).orElse(true);
        boolean lessThanUpperBound = ((AbstractOptional)this.upperBound.map(it -> this.upperBound.isInclusive() ? comparator.compare(it, value) >= 0 : comparator.compare(it, value) > 0)).orElse(true);
        return greaterThanLowerBound && lessThanUpperBound;
    }

    String toPrefixString() {
        return ((AbstractOptional)((Bound)this.lowerBound.map(Object::toString)).map(it -> this.lowerBound.isInclusive() ? "[".concat((String)it) : "(".concat((String)it))).orElse("unbounded");
    }

    String toSuffixString() {
        return ((AbstractOptional)((Bound)this.upperBound.map(Object::toString)).map(it -> this.upperBound.isInclusive() ? it.concat("]") : it.concat(")"))).orElse("unbounded");
    }

    public String toString() {
        return String.format("%s-%s", this.toPrefixString(), this.toSuffixString());
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.lowerBound, this.upperBound});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Range) {
            Range other = (Range)obj;
            return ObjectUtils.equals(this.lowerBound, other.lowerBound) && ObjectUtils.equals(this.upperBound, other.upperBound);
        }
        return false;
    }

    public static class RangeBuilder<T> {
        private final Bound<T> lower;

        RangeBuilder(Bound<T> lower) {
            this.lower = lower;
        }

        public Range<T> to(Bound<T> upper) {
            Assert.notNull(upper, "Upper bound must not be null!");
            return new Range<T>(this.lower, upper);
        }
    }
}

