/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.lang.Nullable;
import io.basc.framework.util.CloseableIterator;
import io.basc.framework.util.StaticSupplier;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class ResponsiveIterator<E>
implements CloseableIterator<E> {
    private static final int DEFAULT_CAPACITY = Integer.getInteger("io.basc.framework.util.stream.ResponsiveIterator.capacity", 128);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean readClosed = new AtomicBoolean(false);
    private final BlockingQueue<ResponsiveMessage<E>> queue;
    private volatile Supplier<E> valueSupplier;

    public ResponsiveIterator() {
        this(DEFAULT_CAPACITY);
    }

    public ResponsiveIterator(int capacity) {
        this.queue = new ArrayBlockingQueue<ResponsiveMessage<E>>(capacity);
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.queue.put(new ResponsiveMessage<Object>(1, null));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void put(E message) throws InterruptedException {
        if (this.isClosed()) {
            return;
        }
        this.queue.put(new ResponsiveMessage<E>(0, message));
    }

    public boolean offer(E message) {
        if (this.isClosed()) {
            return false;
        }
        return this.queue.offer(new ResponsiveMessage<E>(0, message));
    }

    public boolean offer(E message, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.isClosed()) {
            return false;
        }
        return this.queue.offer(new ResponsiveMessage<E>(0, message), timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        if (this.readClosed.get()) {
            return false;
        }
        if (this.valueSupplier == null) {
            ResponsiveIterator responsiveIterator = this;
            synchronized (responsiveIterator) {
                if (this.readClosed.get()) {
                    return false;
                }
                if (this.valueSupplier == null) {
                    if (this.isClosed() && this.queue.isEmpty()) {
                        return false;
                    }
                    try {
                        ResponsiveMessage<E> message = this.queue.take();
                        if (message.type == 1) {
                            if (this.readClosed.compareAndSet(false, true)) {
                                this.queue.clear();
                            }
                            return false;
                        }
                        this.valueSupplier = new StaticSupplier(message.value);
                        return true;
                    }
                    catch (InterruptedException e) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext(long timeout, TimeUnit unit) {
        if (this.readClosed.get()) {
            return false;
        }
        if (this.valueSupplier == null) {
            ResponsiveIterator responsiveIterator = this;
            synchronized (responsiveIterator) {
                if (this.readClosed.get()) {
                    return false;
                }
                if (this.valueSupplier == null) {
                    if (this.closed.get() && this.queue.isEmpty()) {
                        return false;
                    }
                    try {
                        ResponsiveMessage<E> message = this.queue.poll(timeout, unit);
                        if (message == null) {
                            return false;
                        }
                        if (message.type == 1) {
                            if (this.readClosed.compareAndSet(false, true)) {
                                this.queue.clear();
                            }
                            return false;
                        }
                        this.valueSupplier = new StaticSupplier(message.value);
                        return true;
                    }
                    catch (InterruptedException e) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ResponsiveIterator responsiveIterator = this;
        synchronized (responsiveIterator) {
            E value = this.valueSupplier.get();
            this.valueSupplier = null;
            return value;
        }
    }

    private static class ResponsiveMessage<V> {
        public final V value;
        @Nullable
        public final int type;

        public ResponsiveMessage(int type, @Nullable V value) {
            this.value = value;
            this.type = type;
        }
    }
}

