/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.Cursor;
import io.basc.framework.util.EmptyResultSet;
import io.basc.framework.util.StandardResultSet;
import io.basc.framework.util.Streamy;
import java.math.BigInteger;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

@FunctionalInterface
public interface ResultSet<E>
extends Iterable<E>,
Streamy<E> {
    @Override
    public Cursor<E> iterator();

    @Override
    default public Stream<E> stream() {
        return this.iterator().stream();
    }

    @Override
    default public <U> ResultSet<U> flatConvert(Function<? super Stream<E>, ? extends Stream<U>> converter) {
        return ResultSet.of(() -> this.iterator().flatConvert(converter));
    }

    @Override
    default public <U> ResultSet<U> convert(Function<? super E, ? extends U> converter) {
        return ResultSet.of(() -> this.iterator().convert(converter));
    }

    @Override
    default public <U> ResultSet<U> map(Function<? super E, ? extends U> mapper) {
        return ResultSet.of(() -> this.iterator().map(mapper));
    }

    @Override
    default public ResultSet<E> filter(Predicate<? super E> predicate) {
        return ResultSet.of(() -> this.iterator().filter(predicate));
    }

    @Override
    default public ResultSet<E> limit(Predicate<? super E> start, Predicate<? super E> end) {
        return ResultSet.of(() -> this.iterator().limit(start, end));
    }

    @Override
    default public ResultSet<E> limit(BigInteger start, BigInteger count) {
        return ResultSet.of(() -> this.iterator().limit(start, count));
    }

    @Override
    default public ResultSet<E> limit(long start) {
        return this.limit(BigInteger.valueOf(start), null);
    }

    @Override
    default public ResultSet<E> limit(long start, long count) {
        return this.limit(BigInteger.valueOf(start), BigInteger.valueOf(count));
    }

    public static <T> ResultSet<T> empty() {
        return new EmptyResultSet();
    }

    public static <T> ResultSet<T> of(Supplier<? extends Cursor<T>> cursorSupplier) {
        return new StandardResultSet(cursorSupplier);
    }

    public static <T> ResultSet<T> of(List<? extends T> list) {
        return new StandardResultSet<T>(list);
    }
}

