/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.lang.Nullable;
import io.basc.framework.util.Optional;
import io.basc.framework.util.StandardReturn;
import io.basc.framework.util.Status;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface Return<T>
extends Optional<T>,
Status {
    public static <U> Return<U> success() {
        return Return.success(null);
    }

    public static <U> Return<U> success(U value) {
        return Return.success(0L, null, value);
    }

    public static <U> Return<U> success(long code, @Nullable String msg) {
        return Return.success(code, msg, null);
    }

    public static <U> Return<U> success(long code, @Nullable String msg, @Nullable U value) {
        return new StandardReturn<U>(true, code, msg, value);
    }

    public static <U> Return<U> error(@Nullable String msg) {
        return Return.error(0L, msg);
    }

    public static <U> Return<U> error(String msg, @Nullable U value) {
        return Return.error(0L, msg, value);
    }

    public static <U> Return<U> error(long code, @Nullable String msg) {
        return Return.error(code, msg, null);
    }

    public static <U> Return<U> error(long code, @Nullable String msg, @Nullable U value) {
        return new StandardReturn<U>(false, code, msg, value);
    }

    @Override
    public <U> Return<U> convert(Function<? super T, ? extends U> var1);

    @Override
    default public Return<T> ifAbsent(T other) {
        return this.convert((T e) -> e == null ? other : e);
    }

    @Override
    default public Return<T> ifAbsentGet(Supplier<? extends T> other) {
        return this.convert((T e) -> e == null ? other.get() : e);
    }

    @Override
    default public Return<T> filter(Predicate<? super T> predicate) {
        return this.convert((T e) -> e != null && predicate.test(e) ? e : null);
    }

    @Override
    default public <U> Return<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return this.convert((T e) -> e == null ? null : mapper.apply(e));
    }
}

