/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.Streamy;
import io.basc.framework.util.XUtils;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;

public interface ReverseIterator<E>
extends Streamy<E> {
    public boolean hasPrevious();

    public E previous();

    default public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    default public void forEachRemaining(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        while (this.hasPrevious()) {
            action.accept(this.previous());
        }
    }

    @Override
    default public Stream<E> stream() {
        Iterator iterator = new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return ReverseIterator.this.hasPrevious();
            }

            @Override
            public E next() {
                return ReverseIterator.this.previous();
            }

            @Override
            public void remove() {
                ReverseIterator.this.remove();
            }

            @Override
            public void forEachRemaining(Consumer<? super E> action) {
                ReverseIterator.this.forEachRemaining(action);
            }
        };
        return XUtils.stream(iterator);
    }
}

