/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.ConvertibleCursor;
import io.basc.framework.util.FilterableCursor;
import io.basc.framework.util.InvertedSuccessive;
import io.basc.framework.util.ReverseIterator;
import io.basc.framework.util.XUtils;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface ReversibleIterator<E>
extends Iterator<E>,
ReverseIterator<E> {
    @Override
    default public ReversibleIterator<E> limit(long start) {
        return this.limit(BigInteger.valueOf(start), null);
    }

    @Override
    default public ReversibleIterator<E> limit(long start, long count) {
        return this.limit(BigInteger.valueOf(start), BigInteger.valueOf(count));
    }

    @Override
    default public ReversibleIterator<E> limit(BigInteger start, BigInteger count) {
        return new FilterableCursor(this, start, count, null);
    }

    @Override
    default public ReversibleIterator<E> limit(Predicate<? super E> start, Predicate<? super E> end) {
        return new FilterableCursor<E>(this, start, end, null);
    }

    @Override
    default public <U> ReversibleIterator<U> map(Function<? super E, ? extends U> mapper) {
        return new ConvertibleCursor<E, U>(this, mapper, BigInteger.ZERO, null);
    }

    @Override
    default public ReversibleIterator<E> filter(Predicate<? super E> predicate) {
        return new FilterableCursor<E>(this, predicate, null);
    }

    @Override
    default public Stream<E> stream() {
        return XUtils.stream(this);
    }

    default public ReversibleIterator<E> invert() {
        return new InvertedSuccessive(this);
    }

    @Override
    default public void remove() {
        Iterator.super.remove();
    }

    @Override
    default public void forEachRemaining(Consumer<? super E> action) {
        Iterator.super.forEachRemaining(action);
    }
}

