/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.CollectionUtils;
import io.basc.framework.util.Selector;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class RoundRobinSelector<E>
implements Selector<E> {
    private final AtomicInteger position = new AtomicInteger();

    @Override
    public E apply(List<E> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        int pos = Math.abs(this.position.getAndIncrement());
        return list.get(pos %= list.size());
    }
}

