/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.lang.Nullable;
import io.basc.framework.util.RoundRobinSelector;
import io.basc.framework.util.WeightedRandomSelector;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Selector<E>
extends Function<Stream<E>, E> {
    @Override
    @Nullable
    default public E apply(Stream<E> elements) {
        if (elements == null) {
            return null;
        }
        return (E)this.apply(elements.collect(Collectors.toList()));
    }

    @Override
    @Nullable
    public E apply(List<E> var1);

    public static <T> Selector<T> roundRobin() {
        return new RoundRobinSelector();
    }

    public static <T> Selector<T> random() {
        return WeightedRandomSelector.getSingleton();
    }
}

