/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.core.OrderComparator;
import io.basc.framework.lang.Nullable;
import io.basc.framework.util.CollectionUtils;
import io.basc.framework.util.MultiIterator;
import io.basc.framework.util.XUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Services<T>
implements Iterable<T>,
Consumer<T> {
    private T afterService;
    private T beforeService;
    private volatile Services<Consumer<T>> consumers;
    private volatile Collection<T> services;
    private final Supplier<Collection<T>> supplier;

    public Services() {
        this(null);
    }

    public Services(@Nullable Supplier<Collection<T>> supplier) {
        this.supplier = supplier == null ? () -> new ArrayList(8) : supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(T service) {
        if (this.consumers == null) {
            Services services = this;
            synchronized (services) {
                if (this.consumers == null) {
                    return;
                }
            }
        }
        for (Consumer consumer : this.consumers) {
            consumer.accept(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addService(T service) {
        if (service == null) {
            return false;
        }
        this.accept(service);
        Services services = this;
        synchronized (services) {
            if (this.services == null) {
                this.services = this.supplier.get();
            }
            boolean success = this.addService(service, this.services);
            this.postProcessing(this.services);
            return success;
        }
    }

    protected boolean addService(T service, Collection<T> targetServices) {
        return targetServices.add(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addServices(Iterable<? extends T> services) {
        if (services == null) {
            return false;
        }
        boolean success = false;
        Services services2 = this;
        synchronized (services2) {
            for (T service : services) {
                if (service == null) continue;
                this.accept(service);
                if (this.services == null) {
                    this.services = this.supplier.get();
                }
                if (!this.addService(service, this.services) || success) continue;
                success = true;
            }
            if (this.services != null) {
                this.postProcessing(this.services);
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.services == null) {
            return;
        }
        Services services = this;
        synchronized (services) {
            this.services.clear();
        }
    }

    public final T getAfterService() {
        return this.afterService;
    }

    public final T getBeforeService() {
        return this.beforeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Services<Consumer<T>> getConsumers() {
        if (this.consumers == null) {
            Services services = this;
            synchronized (services) {
                if (this.consumers == null) {
                    this.consumers = new Services<T>();
                }
            }
        }
        return this.consumers;
    }

    public final Collection<T> getTargetServices() {
        return this.services == null ? Collections.emptyList() : Collections.unmodifiableCollection(this.services);
    }

    public boolean isEmpty() {
        return this.afterService == null && this.beforeService == null && CollectionUtils.isEmpty(this.services);
    }

    @Override
    public Iterator<T> iterator() {
        T before = this.getBeforeService();
        T after = this.getAfterService();
        return new MultiIterator(before == null ? Collections.emptyIterator() : Arrays.asList(before).iterator(), this.services == null ? Collections.emptyIterator() : this.services.iterator(), after == null ? Collections.emptyIterator() : Arrays.asList(after).iterator());
    }

    public void postProcessing(Collection<T> service) {
        if (this.services.getClass() == ArrayList.class) {
            ((ArrayList)this.services).sort(OrderComparator.INSTANCE);
        }
    }

    public void setAfterService(T afterService) {
        this.afterService = afterService;
    }

    public void setBeforeService(T beforeService) {
        this.beforeService = beforeService;
    }

    public Stream<T> stream() {
        return XUtils.stream(this.iterator());
    }

    public String toString() {
        return this.stream().collect(Collectors.toList()).toString();
    }
}

