/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.StringMatcher;
import io.basc.framework.util.StringUtils;

public class SimpleStringMatcher
implements StringMatcher {
    private boolean testInternal(String text, String match) {
        if (text == null) {
            return "*".equals(match);
        }
        if ("*".equals(match)) {
            return true;
        }
        if (match.indexOf("*") == -1) {
            if (match.indexOf("?") == -1) {
                return text.equals(match);
            }
            return this.test(text, match, '?', false);
        }
        String[] arr = StringUtils.splitToArray((CharSequence)match, false, false, "*");
        if (!match.startsWith("*") && !text.startsWith(arr[0])) {
            return false;
        }
        if (!match.endsWith("*") && !text.endsWith(arr[arr.length - 1])) {
            return false;
        }
        int begin = 0;
        int len = text.length();
        for (String v : arr) {
            int a;
            int vLen = v.length();
            if (len < vLen) {
                return false;
            }
            boolean b = false;
            for (a = begin; a < len; ++a) {
                int end = a + vLen;
                if (end > text.length()) {
                    return false;
                }
                String c = text.substring(a, end);
                if (!this.test(c, v, '?', false)) continue;
                b = true;
                break;
            }
            if (!b) {
                return false;
            }
            begin = a + vLen;
        }
        return true;
    }

    private boolean test(String text, String match, char matchChar, boolean multiple) {
        if (match.indexOf(matchChar) == -1) {
            return text.equals(match);
        }
        int size = match.length();
        if (multiple) {
            int index = 0;
            int findIndex = 0;
            for (int i = 0; i < size; ++i) {
                char c = match.charAt(i);
                if (c != matchChar) continue;
                String v = match.substring(index, i);
                index = i;
                if (v.length() == 0) continue;
                int tempIndex = text.indexOf(v, findIndex);
                if (tempIndex == -1) {
                    return false;
                }
                findIndex = tempIndex + v.length();
            }
            return true;
        }
        if (text.length() != size) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (match.charAt(i) == matchChar || match.charAt(i) == text.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isPattern(String text) {
        return !StringUtils.isEmpty(text) && (text.indexOf("!") != -1 || text.indexOf("?") != -1 || text.indexOf("*") != -1);
    }

    @Override
    public boolean match(String pattern, String text) {
        if (StringUtils.isEmpty(pattern)) {
            return false;
        }
        if (pattern.startsWith("!")) {
            return !this.testInternal(text, pattern.substring(1));
        }
        return this.testInternal(text, pattern);
    }
}

