/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.CollectionFactory;
import io.basc.framework.util.ObjectUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SmartMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<K, V> targetMap;

    public SmartMap(boolean concurrent) {
        this(concurrent ? new ConcurrentHashMap() : new HashMap());
    }

    public SmartMap(boolean concurrent, int initialCapacity) {
        this(concurrent ? new ConcurrentHashMap(initialCapacity) : new HashMap(initialCapacity));
    }

    public SmartMap(Map<K, V> targetMap) {
        this.targetMap = targetMap;
    }

    public Map<K, V> getTargetMap() {
        return this.targetMap;
    }

    @Override
    public int size() {
        return this.targetMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.targetMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.targetMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.targetMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.targetMap.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.targetMap.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.targetMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.targetMap.putAll(m);
    }

    @Override
    public void clear() {
        this.targetMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.targetMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.targetMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.targetMap.entrySet();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.targetMap.putIfAbsent(key, value);
    }

    public boolean isConcurrent() {
        return this.targetMap instanceof ConcurrentMap;
    }

    public String toString() {
        return this.targetMap.toString();
    }

    @Override
    public int hashCode() {
        return this.targetMap.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return ObjectUtils.equals(this.targetMap, obj);
    }

    public SmartMap<K, V> clone() {
        return new SmartMap<K, V>(CollectionFactory.clone(this.targetMap));
    }
}

