/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.lang.Nullable;
import io.basc.framework.util.Closeable;
import io.basc.framework.util.RunnableProcessor;
import io.basc.framework.util.XUtils;
import java.util.concurrent.atomic.AtomicBoolean;

public class StandardCloseable<E extends Throwable, C extends Closeable<E>>
implements Closeable<E> {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private RunnableProcessor<? extends E> closeHandler;

    public StandardCloseable() {
        this(null);
    }

    public StandardCloseable(@Nullable RunnableProcessor<? extends E> closeHandler) {
        this.closeHandler = closeHandler;
    }

    @Override
    public void close() throws E {
        if (this.closed.compareAndSet(false, true) && this.closeHandler != null) {
            this.closeHandler.process();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    public C onClose(RunnableProcessor<? extends E> closeHandler) {
        if (closeHandler == null) {
            return (C)this;
        }
        this.closeHandler = this.closeHandler == null ? closeHandler : XUtils.composeWithExceptions(this.closeHandler, closeHandler);
        return (C)this;
    }
}

