/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.AbstractCursor;
import io.basc.framework.util.Assert;
import io.basc.framework.util.CloseableIterator;
import io.basc.framework.util.ReversibleIterator;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class StandardCursor<E, C extends StandardCursor<E, C>>
extends AbstractCursor<E, C> {
    private BigInteger position;
    private final Iterator<? extends E> iterator;

    public StandardCursor(CloseableIterator<? extends E> iterator) {
        this(iterator, BigInteger.ZERO);
    }

    public StandardCursor(Iterator<? extends E> iterator) {
        this(iterator, BigInteger.ZERO);
    }

    public StandardCursor(CloseableIterator<? extends E> iterator, BigInteger position) {
        this((Iterator<? extends E>)iterator, position);
        super.onClose(() -> iterator.close());
    }

    public StandardCursor(Iterator<? extends E> iterator, BigInteger position) {
        Assert.requiredArgument(iterator != null, "iterator");
        Assert.requiredArgument(position != null, "position");
        this.iterator = iterator;
        this.position = position;
    }

    @Override
    public BigInteger getPosition() {
        return this.position;
    }

    @Override
    public boolean hasNext() {
        if (this.isClosed()) {
            return false;
        }
        if (this.iterator.hasNext()) {
            return true;
        }
        this.close();
        return false;
    }

    @Override
    public boolean hasPrevious() {
        if (this.isClosed()) {
            return false;
        }
        if (this.position.compareTo(BigInteger.ZERO) > 0 && (this.iterator instanceof ReversibleIterator ? ((ReversibleIterator)this.iterator).hasPrevious() : this.iterator instanceof ListIterator && ((ListIterator)this.iterator).hasPrevious())) {
            return true;
        }
        this.close();
        return false;
    }

    @Override
    public E previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException(this.getClass().getName() + "#previous");
        }
        try {
            if (this.iterator instanceof ReversibleIterator) {
                Object e = ((ReversibleIterator)this.iterator).previous();
                return e;
            }
            if (this.iterator instanceof ListIterator) {
                Object e = ((ListIterator)this.iterator).previous();
                return e;
            }
            throw Assert.shouldNeverGetHere();
        }
        finally {
            this.position = this.position.subtract(BigInteger.ONE);
        }
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException(this.getClass().getName() + "#next");
        }
        try {
            E e = this.iterator.next();
            return e;
        }
        finally {
            this.position = this.position.add(BigInteger.ONE);
        }
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

