/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.Cursor;
import io.basc.framework.util.ResultSet;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;

public class StandardResultSet<E>
implements ResultSet<E> {
    private final transient Supplier<? extends Cursor<E>> cursorSupplier;
    private volatile Iterable<? extends E> iterable;

    public StandardResultSet(Iterable<? extends E> iterable) {
        this.cursorSupplier = null;
        this.iterable = iterable;
    }

    public StandardResultSet(Supplier<? extends Cursor<E>> cursorSupplier) {
        this.cursorSupplier = cursorSupplier;
    }

    @Override
    public Cursor<E> iterator() {
        if (this.iterable != null) {
            return Cursor.of(this.iterable);
        }
        return this.cursorSupplier.get();
    }

    @Override
    public E last() {
        if (this.iterable instanceof List) {
            List list = (List)this.iterable;
            return list.get(list.size() - 1);
        }
        return ResultSet.super.last();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<E> toList() {
        if (this.iterable == null && !(this.iterable instanceof List)) {
            StandardResultSet standardResultSet = this;
            synchronized (standardResultSet) {
                if (this.iterable == null && !(this.iterable instanceof List)) {
                    this.iterable = ResultSet.super.toList();
                }
            }
        }
        return Collections.unmodifiableList((List)this.iterable);
    }
}

