/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.lang.Nullable;
import io.basc.framework.util.Assert;
import io.basc.framework.util.Return;
import io.basc.framework.util.StandardReturn;
import io.basc.framework.util.StandardStatus;
import io.basc.framework.util.StringUtils;
import java.io.Serializable;

public interface Status
extends Serializable {
    public static Status success() {
        return Status.success(null);
    }

    public static Status success(String msg) {
        return Status.success(0L, msg);
    }

    public static Status success(long code, String msg) {
        return new StandardStatus(true, code, msg);
    }

    public static Status error(@Nullable String msg) {
        return Status.error(0L, msg);
    }

    public static Status error(long code, @Nullable String msg) {
        return new StandardStatus(false, code, msg);
    }

    public boolean isSuccess();

    default public boolean isError() {
        return !this.isSuccess();
    }

    public long getCode();

    @Nullable
    public String getMsg();

    default public void assertSuccess() {
        String msg = this.getMsg();
        if (StringUtils.isEmpty(msg)) {
            Assert.isTrue(this.isSuccess());
        } else {
            Assert.isTrue(this.isSuccess(), msg);
        }
    }

    default public <T> Return<T> toReturn() {
        return this.toReturn(null);
    }

    default public <T> Return<T> toReturn(@Nullable T value) {
        return new StandardReturn<T>(this.isSuccess(), this.getCode(), this.getMsg(), value);
    }
}

