/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.lang.Nullable;
import io.basc.framework.util.ConsumeProcessor;
import io.basc.framework.util.Cursor;
import io.basc.framework.util.FilterableCursor;
import io.basc.framework.util.Optional;
import io.basc.framework.util.Processor;
import io.basc.framework.util.Source;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@FunctionalInterface
public interface Streamy<E>
extends Optional<E> {
    public Stream<E> stream();

    default public Streamy<E> limit(long start) {
        return this.limit(BigInteger.valueOf(start), null);
    }

    default public Streamy<E> limit(long start, long count) {
        return this.limit(BigInteger.valueOf(start), BigInteger.valueOf(count));
    }

    default public Streamy<E> limit(BigInteger start, @Nullable BigInteger count) {
        Stream stream = this.stream();
        try {
            return new FilterableCursor(Cursor.of(stream.iterator()), start, count, () -> stream.close());
        }
        catch (Throwable e) {
            stream.close();
            throw e;
        }
    }

    default public Streamy<E> limit(@Nullable Predicate<? super E> start, @Nullable Predicate<? super E> end) {
        Stream stream = this.stream();
        try {
            return new FilterableCursor<E>(Cursor.of(stream.iterator()), start, end, () -> stream.close());
        }
        catch (Throwable e) {
            stream.close();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <R, A> R collect(Collector<? super E, A, R> collector) {
        try (Stream<E> stream = this.stream();){
            R r = stream.collect(collector);
            return r;
        }
    }

    default public java.util.Optional<E> findFirst() {
        try (Stream<E> stream = this.stream();){
            java.util.Optional<E> optional = stream.findFirst();
            return optional;
        }
    }

    default public java.util.Optional<E> findAny() {
        try (Stream<E> stream = this.stream();){
            java.util.Optional<E> optional = stream.findAny();
            return optional;
        }
    }

    @Override
    default public E get() {
        return this.findFirst().get();
    }

    @Override
    default public E orElse(E other) {
        return this.findFirst().orElse(other);
    }

    @Override
    default public <X extends Throwable> E orElseGet(Source<? extends E, ? extends X> other) throws X {
        java.util.Optional<E> optional = this.findFirst();
        return optional.isPresent() ? optional.get() : other.get();
    }

    @Override
    default public boolean isPresent() {
        return this.findFirst().isPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public E first() {
        try (Stream<E> stream = this.stream();){
            Iterator iterator = stream.iterator();
            E e = iterator.hasNext() ? (E)iterator.next() : null;
            return e;
        }
    }

    default public Object[] toArray() {
        return this.toList().toArray();
    }

    default public <T> T[] toArray(T[] array) {
        return this.toList().toArray(array);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <A> A[] toArray(IntFunction<A[]> generator) {
        try (Stream<E> stream = this.stream();){
            A[] AArray = stream.toArray(generator);
            return AArray;
        }
    }

    default public List<E> toList() {
        return this.collect(Collectors.toList());
    }

    default public Set<E> toSet() {
        return this.collect(Collectors.toCollection(() -> new LinkedHashSet()));
    }

    default public <K> Map<K, E> toMap(Function<? super E, ? extends K> keyMapper) {
        return this.toMap(keyMapper, Function.identity());
    }

    default public <K, V> Map<K, V> toMap(Function<? super E, ? extends K> keyMapper, Function<? super E, ? extends V> valueMapper) {
        return this.toMap(keyMapper, valueMapper, () -> new LinkedHashMap());
    }

    default public <K, V, M extends Map<K, V>> M toMap(Function<? super E, ? extends K> keyMapper, Function<? super E, ? extends V> valueMapper, Supplier<? extends M> mapSupplier) {
        return (M)((Map)this.collect(Collectors.toMap(keyMapper, valueMapper, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, mapSupplier)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public E last() {
        try (Stream<E> stream = this.stream();){
            Iterator iterator = stream.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (iterator.hasNext()) continue;
                Object t = e;
                return (E)t;
            }
            E e = null;
            return e;
        }
    }

    default public <U> Streamy<U> flatConvert(Function<? super Stream<E>, ? extends Stream<U>> converter) {
        return () -> (Stream)converter.apply(this.stream());
    }

    @Override
    default public <U> Streamy<U> convert(Function<? super E, ? extends U> converter) {
        return () -> this.stream().map(converter);
    }

    @Override
    default public <U> Streamy<U> map(Function<? super E, ? extends U> mapper) {
        return () -> this.stream().map(mapper);
    }

    @Override
    default public Streamy<E> filter(Predicate<? super E> predicate) {
        Stream stream = this.stream();
        try {
            return new FilterableCursor<E>(Cursor.of(stream.iterator()), predicate, () -> stream.close());
        }
        catch (Throwable e) {
            stream.close();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T, X extends Throwable> T export(Processor<? super Stream<E>, ? extends T, ? extends X> processor) throws X {
        try (Stream<E> stream = this.stream();){
            T t = processor.process(stream);
            return t;
        }
    }

    default public <X extends Throwable> void transfer(ConsumeProcessor<? super Stream<E>, ? extends X> processor) throws X {
        try (Stream<E> stream = this.stream();){
            processor.process(stream);
        }
    }
}

