/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.SimpleStringMatcher;
import io.basc.framework.util.StringMatcher;
import io.basc.framework.util.StringUtils;

public enum StringMatchers implements StringMatcher
{
    NOTHING,
    PREFIX,
    SIMPLE;

    private static final SimpleStringMatcher simpleStringMatcher;

    @Override
    public boolean isPattern(String text) {
        if (text == null) {
            return false;
        }
        switch (this) {
            case PREFIX: {
                return true;
            }
            case SIMPLE: {
                return simpleStringMatcher.isPattern(text);
            }
        }
        return false;
    }

    @Override
    public boolean match(String pattern, String text) {
        switch (this) {
            case PREFIX: {
                return text.startsWith(pattern);
            }
            case SIMPLE: {
                return simpleStringMatcher.match(pattern, text);
            }
        }
        return false;
    }

    public static boolean match(StringMatcher stringMatcher, String pattern, String text) {
        if (pattern != null && stringMatcher.isPattern(pattern)) {
            return stringMatcher.match(pattern, text);
        }
        return StringUtils.equals(pattern, text);
    }

    public static boolean matchAny(String pattern, String text) {
        for (StringMatchers matchers : StringMatchers.values()) {
            if (!matchers.match(pattern, text)) continue;
            return true;
        }
        return false;
    }

    static {
        simpleStringMatcher = new SimpleStringMatcher();
    }
}

