/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.StringToNumber;
import io.basc.framework.util.StringUtils;
import java.util.function.ToDoubleFunction;

public class StringToDouble
extends StringToNumber
implements ToDoubleFunction<String> {
    public static final StringToDouble DEFAULT = new StringToDouble(0.0);
    private final double defaultValue;

    public StringToDouble(double defaultValue) {
        super(false, 10);
        this.defaultValue = defaultValue;
    }

    public double getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Double apply(String source) {
        String value = this.format(source);
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        return Double.valueOf(value);
    }

    @Override
    public double applyAsDouble(String source) {
        Double v = this.apply(source);
        return v == null ? this.defaultValue : v;
    }
}

