/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.StringToNumber;
import io.basc.framework.util.StringUtils;

public class StringToFloat
extends StringToNumber {
    public static final StringToFloat DEFAULT = new StringToFloat(0.0f);
    private final float defaultValue;

    public StringToFloat(float defaultValue) {
        super(false, 10);
        this.defaultValue = defaultValue;
    }

    public float getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Float apply(String source) {
        String value = this.format(source);
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        return Float.valueOf(value);
    }

    public float applyAsFloat(String source) {
        Float value = this.apply(source);
        return value == null ? this.defaultValue : value.floatValue();
    }
}

