/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.StringToNumber;
import io.basc.framework.util.StringUtils;
import java.util.function.ToLongFunction;

public class StringToLong
extends StringToNumber
implements ToLongFunction<String> {
    public static final StringToLong DEFAULT = new StringToLong(false, 10, 0L);
    private final long defaultValue;

    public StringToLong(boolean unsigned, int radix, long defaultValue) {
        super(unsigned, radix);
        this.defaultValue = defaultValue;
    }

    public long getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Long apply(String source) {
        String value = this.format(source);
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        return this.isUnsigned() ? Long.parseUnsignedLong(value, this.getRadix()) : Long.valueOf(value, this.getRadix());
    }

    @Override
    public long applyAsLong(String source) {
        Long value = this.apply(source);
        return value == null ? this.defaultValue : value;
    }
}

