/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.lang.Nullable;
import io.basc.framework.util.StringUtils;
import java.math.BigDecimal;
import java.util.function.Function;
import java.util.function.IntPredicate;

public class StringToNumber
implements Function<String, Number> {
    public static final StringToNumber DEFAULT = new StringToNumber(false, 10);
    private final boolean unsigned;
    private final int radix;

    public StringToNumber(boolean unsigned, int radix) {
        this.unsigned = unsigned;
        this.radix = radix;
    }

    public boolean isUnsigned() {
        return this.unsigned;
    }

    public int getRadix() {
        return this.radix;
    }

    @Override
    @Nullable
    public Number apply(String source) {
        String value = this.format(source);
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        return new BigDecimal(value);
    }

    public String format(String source) throws NumberFormatException {
        if (StringUtils.isEmpty(source)) {
            return source;
        }
        String numberString = source.trim();
        if (numberString.isEmpty()) {
            return numberString;
        }
        if (this.unsigned && numberString.startsWith("-")) {
            throw new NumberFormatException("Cannot contain symbols");
        }
        if (numberString.startsWith("+")) {
            numberString = numberString.substring(0);
        }
        return numberString;
    }

    public String extractNumberic(CharSequence source) {
        return this.extractNumberic(source, c -> this.radix > 10 || this.radix <= 0 ? Character.isLetterOrDigit(c) : Character.isDigit(c));
    }

    @Nullable
    public String extractNumberic(@Nullable CharSequence source, @Nullable IntPredicate filter) {
        if (StringUtils.isEmpty(source)) {
            return null;
        }
        char[] chars = new char[source.length()];
        int pos = 0;
        boolean findPoint = false;
        int len = source.length();
        for (int i = 0; i < len; ++i) {
            char chr = source.charAt(i);
            if (StringToNumber.isNumberSign(chr)) {
                if (pos == 0 && this.unsigned && chr == '-') {
                    return null;
                }
                chars[pos++] = chr;
                continue;
            }
            if (this.radix > 10 && chr == '#' && !findPoint && (pos == 0 || pos == 1 && StringToNumber.isNumberSign(chars[0]))) {
                chars[pos++] = chr;
                continue;
            }
            if (chr == '.') {
                if (findPoint) continue;
                findPoint = true;
                chars[pos++] = chr;
                continue;
            }
            if (filter != null && !filter.test(chr)) continue;
            chars[pos++] = chr;
        }
        return pos == 0 ? null : new String(chars, 0, pos);
    }

    private static boolean isNumberSign(char chr) {
        return chr == '-' || chr == '+';
    }

    public boolean isNumeric(String source) {
        String numberString;
        try {
            numberString = this.format(source);
        }
        catch (NumberFormatException ignore) {
            return false;
        }
        if (this.isNumeric(numberString, c -> this.radix > 10 || this.radix <= 0 ? Character.isLetterOrDigit(c) : Character.isDigit(c))) {
            return true;
        }
        try {
            this.apply(numberString);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public boolean isNumeric(@Nullable CharSequence source, @Nullable IntPredicate filter) {
        if (StringUtils.isEmpty(source)) {
            return false;
        }
        boolean findPoint = false;
        char[] chars = new char[source.length()];
        int pos = 0;
        int len = source.length();
        for (int i = 0; i < len; ++i) {
            char chr = source.charAt(i);
            if (chr == '-' || chr == '+') {
                if (pos == 0) {
                    if (this.unsigned && chr == '-') {
                        return false;
                    }
                    ++pos;
                    continue;
                }
                return false;
            }
            if (this.radix > 10 && chr == '#') {
                if (!findPoint && (pos == 0 || pos == 1 && StringToNumber.isNumberSign(chars[0]))) {
                    chars[pos++] = chr;
                    continue;
                }
                return false;
            }
            if (chr == '.') {
                if (findPoint) {
                    return false;
                }
                findPoint = true;
                ++pos;
                continue;
            }
            if (filter != null && !filter.test(chr)) {
                return false;
            }
            ++pos;
        }
        return true;
    }
}

