/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.lang.Nullable;
import io.basc.framework.util.ArrayUtils;
import io.basc.framework.util.Assert;
import io.basc.framework.util.CharSequenceSplitIterator;
import io.basc.framework.util.CharSequenceSplitSegment;
import io.basc.framework.util.CollectionUtils;
import io.basc.framework.util.ObjectUtils;
import io.basc.framework.util.Pair;
import io.basc.framework.util.XUtils;
import io.basc.framework.util.placeholder.PlaceholderFormat;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.function.IntPredicate;
import java.util.stream.Stream;

public final class StringUtils {
    private static final String CURRENT_PATH = ".";
    private static final String[] DEFAULT_SEPARATOR = new String[]{" ", ",", ";", "\u3001"};
    public static final String[] EMPTY_ARRAY = new String[0];
    private static final char EXTENSION_SEPARATOR = '.';
    private static final String FOLDER_SEPARATOR = "/";
    private static final String TOP_PATH = "..";
    private static final String WINDOWS_FOLDER_SEPARATOR = "\\";

    public static String applyRelativePath(String path, String relativePath) {
        int separatorIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        if (separatorIndex != -1) {
            String newPath = path.substring(0, separatorIndex);
            if (!relativePath.startsWith(FOLDER_SEPARATOR)) {
                newPath = newPath + FOLDER_SEPARATOR;
            }
            return newPath + relativePath;
        }
        return relativePath;
    }

    public static String arrayToCommaDelimitedString(Object[] arr) {
        return StringUtils.arrayToDelimitedString(arr, ",");
    }

    public static String arrayToDelimitedString(Object[] arr, String delim) {
        if (ObjectUtils.isEmpty(arr)) {
            return "";
        }
        if (arr.length == 1) {
            return ObjectUtils.toString(arr[0]);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    public static String capitalize(String str) {
        return StringUtils.changeFirstCharacterCase(str, true);
    }

    private static String changeFirstCharacterCase(String str, boolean capitalize) {
        char updatedChar;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        char baseChar = str.charAt(0);
        if (baseChar == (updatedChar = capitalize ? Character.toUpperCase(baseChar) : Character.toLowerCase(baseChar))) {
            return str;
        }
        char[] chars = str.toCharArray();
        chars[0] = updatedChar;
        return new String(chars, 0, chars.length);
    }

    public static String cleanPath(String path) {
        int i;
        if (path == null) {
            return null;
        }
        String pathToUse = StringUtils.replace(path, WINDOWS_FOLDER_SEPARATOR, FOLDER_SEPARATOR);
        int prefixIndex = pathToUse.indexOf(":");
        String prefix = "";
        String suffix = "";
        if (prefixIndex != -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            pathToUse = pathToUse.substring(prefixIndex + 1);
        }
        if (pathToUse.startsWith(FOLDER_SEPARATOR)) {
            prefix = prefix + FOLDER_SEPARATOR;
            pathToUse = pathToUse.substring(1);
        }
        if (pathToUse.endsWith(FOLDER_SEPARATOR)) {
            suffix = suffix + FOLDER_SEPARATOR;
        }
        String[] pathArray = StringUtils.splitToArray((CharSequence)pathToUse, false, true, FOLDER_SEPARATOR);
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (i = pathArray.length - 1; i >= 0; --i) {
            String element = pathArray[i];
            if (CURRENT_PATH.equals(element)) continue;
            if (TOP_PATH.equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        for (i = 0; i < tops; ++i) {
            pathElements.add(0, TOP_PATH);
        }
        if (pathElements.isEmpty()) {
            if (prefix.endsWith(suffix)) {
                return prefix;
            }
            return prefix + suffix;
        }
        return prefix + StringUtils.collectionToDelimitedString(pathElements, FOLDER_SEPARATOR) + suffix;
    }

    public static String collectionToCommaDelimitedString(Collection<?> coll) {
        return StringUtils.collectionToDelimitedString(coll, ",");
    }

    public static String collectionToDelimitedString(Collection<?> coll, String delim) {
        return StringUtils.collectionToDelimitedString(coll, delim, "", "");
    }

    public static String collectionToDelimitedString(Collection<?> coll, String delim, String prefix, String suffix) {
        if (CollectionUtils.isEmpty(coll)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<?> it = coll.iterator();
        while (it.hasNext()) {
            sb.append(prefix).append(it.next()).append(suffix);
            if (!it.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static String complemented(String text, char complemented, int length) {
        Assert.isTrue(length >= text.length(), "The length of text[" + text + "] exceeds the target length[" + length + "]");
        if (length == text.length()) {
            return text;
        }
        CharBuffer charBuffer = CharBuffer.allocate(length);
        for (int i = 0; i < length - text.length(); ++i) {
            charBuffer.put(complemented);
        }
        charBuffer.put(text);
        return new String(charBuffer.array());
    }

    public static String[] concatenateStringArrays(String[] array1, String[] array2) {
        if (ObjectUtils.isEmpty(array1)) {
            return array2;
        }
        if (ObjectUtils.isEmpty(array2)) {
            return array1;
        }
        String[] newArr = new String[array1.length + array2.length];
        System.arraycopy(array1, 0, newArr, 0, array1.length);
        System.arraycopy(array2, 0, newArr, array1.length, array2.length);
        return newArr;
    }

    public static boolean contains(String text, String index, boolean ignoreCase) {
        if (text == null || index == null) {
            return text == index;
        }
        if (ignoreCase) {
            return text.toLowerCase().contains(index.toLowerCase());
        }
        return text.contains(index);
    }

    public static boolean containsChinese(CharSequence charSequence) {
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        for (int i = 0; i < charSequence.length(); ++i) {
            if (!StringUtils.isChinese(charSequence.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsWhitespace(CharSequence str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (!Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String convertUnicode(String ori) {
        int len = ori.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = ori.charAt(x++)) == 92) {
                if ((aChar = ori.charAt(x++)) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = ori.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed   \\uxxxx   encoding.");
                            }
                        }
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }

    public static int count(CharSequence charSequence, CharSequence target) {
        return StringUtils.count(charSequence, 0, target);
    }

    public static int count(CharSequence charSequence, int beginIndex, CharSequence target) {
        if (charSequence == null) {
            return 0;
        }
        return StringUtils.count(charSequence, beginIndex, charSequence.length(), target);
    }

    public static int count(CharSequence charSequence, int beginIndex, int endIndex, CharSequence target) {
        if (charSequence == null || target == null) {
            return 0;
        }
        int count = 0;
        int index = StringUtils.indexOf(charSequence, target, beginIndex, endIndex);
        while (index != -1) {
            ++count;
            index = StringUtils.indexOf(charSequence, target, index + target.length(), endIndex);
        }
        return count;
    }

    public static String delete(String inString, String pattern) {
        return StringUtils.replace(inString, pattern, "");
    }

    public static String deleteAny(String inString, String charsToDelete) {
        if (StringUtils.isEmpty(inString) || StringUtils.isEmpty(charsToDelete)) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < inString.length(); ++i) {
            char c = inString.charAt(i);
            if (charsToDelete.indexOf(c) != -1) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        if (str == null || suffix == null) {
            return false;
        }
        if (str.endsWith(suffix)) {
            return true;
        }
        if (str.length() < suffix.length()) {
            return false;
        }
        String lcStr = str.substring(str.length() - suffix.length()).toLowerCase();
        String lcSuffix = suffix.toLowerCase();
        return lcStr.equals(lcSuffix);
    }

    public static boolean equals(CharSequence cs, boolean ignoreCase, int thisStart, CharSequence substring, int start, int length) {
        if (cs == null || substring == null) {
            return cs == substring;
        }
        if (cs instanceof String && substring instanceof String) {
            return ((String)cs).regionMatches(ignoreCase, thisStart, (String)substring, start, length);
        }
        int index1 = thisStart;
        int index2 = start;
        int tmpLen = length;
        int srcLen = cs.length() - thisStart;
        int otherLen = substring.length() - start;
        if (thisStart < 0 || start < 0 || length < 0) {
            return false;
        }
        if (srcLen < length || otherLen < length) {
            return false;
        }
        while (tmpLen-- > 0) {
            char c2;
            char c1;
            if ((c1 = cs.charAt(index1++)) == (c2 = substring.charAt(index2++))) continue;
            if (!ignoreCase) {
                return false;
            }
            if (Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(CharSequence a, CharSequence b) {
        return StringUtils.equals(a, b, false);
    }

    public static boolean equals(CharSequence a, CharSequence b, boolean ignoreCase) {
        return StringUtils.equals(a, ignoreCase, 0, b, 0, a.length());
    }

    public static boolean equals(String a, String b) {
        return StringUtils.equals(a, b, false);
    }

    public static boolean equals(String a, String b, boolean ignoreCase) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a.length() == 0 || b.length() == 0) {
            return a.length() == b.length();
        }
        return ignoreCase ? a.equalsIgnoreCase(b) : a.equals(b);
    }

    public static boolean equalsAny(CharSequence cs, boolean ignoreCase, CharSequence ... substring) {
        if (substring == null) {
            return false;
        }
        for (CharSequence sub : substring) {
            if (!StringUtils.equals(cs, sub, ignoreCase)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsAny(CharSequence cs, int thisStart, boolean ignoreCase, int start, int length, CharSequence ... substring) {
        if (substring == null) {
            return false;
        }
        for (CharSequence sub : substring) {
            if (!StringUtils.equals(cs, ignoreCase, thisStart, sub, start, length)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsAny(String a, boolean ignoreCase, String ... array) {
        if (array == null) {
            return false;
        }
        for (String b : array) {
            if (!StringUtils.equals(a, b, ignoreCase)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsAny(String a, String ... array) {
        return StringUtils.equalsAny(a, false, array);
    }

    public static String filter(@Nullable CharSequence source, @Nullable IntPredicate filter) {
        if (source == null) {
            return null;
        }
        if (source.length() == 0 || filter == null) {
            return source.toString();
        }
        char[] chars = new char[source.length()];
        int pos = 0;
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (!filter.test(c)) continue;
            chars[pos++] = c;
        }
        return pos == 0 ? null : new String(chars, 0, pos);
    }

    public static String getFilename(String path) {
        if (path == null) {
            return null;
        }
        int separatorIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        return separatorIndex != -1 ? path.substring(separatorIndex + 1) : path;
    }

    public static String getFilenameExtension(String path) {
        if (path == null) {
            return null;
        }
        int extIndex = path.lastIndexOf(46);
        if (extIndex == -1) {
            return null;
        }
        int folderIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        if (folderIndex > extIndex) {
            return null;
        }
        return path.substring(extIndex + 1);
    }

    public static boolean hasText(CharSequence value) {
        if (value == null) {
            return false;
        }
        int len = value.length();
        if (len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasText(CharSequence value, int fromIndex, int endIndex) {
        if (fromIndex == endIndex) {
            return false;
        }
        if (StringUtils.isEmpty(value)) {
            return false;
        }
        int end = Math.min(value.length(), endIndex);
        for (int i = fromIndex; i < end; ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasTextAll(CharSequence ... values) {
        if (values == null || values.length == 0) {
            return false;
        }
        for (CharSequence s : values) {
            if (StringUtils.hasText(s)) continue;
            return false;
        }
        return true;
    }

    public static String humpNamingReplacement(String humpNaming, String replacement) {
        int len = humpNaming.length();
        StringBuilder sb = new StringBuilder(len * 2);
        for (int i = 0; i < len; ++i) {
            char c = humpNaming.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i != 0) {
                    sb.append(replacement);
                }
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static int indexOf(char[] source, char[] target) {
        return StringUtils.indexOf(source, target, 0);
    }

    public static Pair<Integer, Integer> indexOf(char[] source, char[] prefix, char[] suffix, int fromIndex, int endIndex) {
        if (source == null || prefix == null || suffix == null) {
            return null;
        }
        int begin = StringUtils.indexOf(source, prefix, 0, endIndex);
        if (begin == -1) {
            return null;
        }
        int end = StringUtils.indexOf(source, suffix, begin + prefix.length, endIndex);
        if (end == -1) {
            return null;
        }
        int tempBegin = begin;
        int tempEnd = end;
        block0: while (true) {
            int index;
            int nestingLevel = 0;
            while ((index = StringUtils.indexOf(source, prefix, tempBegin + prefix.length, tempEnd)) != -1) {
                ++nestingLevel;
                tempBegin = index;
            }
            if (nestingLevel == 0) break;
            int i = 0;
            while (true) {
                if (i >= nestingLevel) continue block0;
                if ((tempEnd = StringUtils.indexOf(source, suffix, tempEnd + suffix.length, endIndex)) == -1) {
                    return null;
                }
                ++i;
            }
            break;
        }
        return new Pair<Integer, Integer>(begin, tempEnd);
    }

    public static int indexOf(char[] source, char[] target, int fromIndex) {
        return StringUtils.indexOf(source, target, fromIndex, source.length);
    }

    public static int indexOf(char[] source, char[] target, int fromIndex, int endIndex) {
        int index = StringUtils.indexOf(source, fromIndex, endIndex - fromIndex, target, 0, target.length, 0);
        return index == -1 ? -1 : index + fromIndex;
    }

    public static int indexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = target[targetOffset];
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    public static int indexOf(CharSequence source, CharSequence target) {
        return StringUtils.indexOf(source, target, 0);
    }

    public static Pair<Integer, Integer> indexOf(CharSequence text, CharSequence prefix, CharSequence suffix) {
        return StringUtils.indexOf(text, prefix, suffix, 0);
    }

    public static Pair<Integer, Integer> indexOf(CharSequence source, CharSequence prefix, CharSequence suffix, int fromIndex) {
        if (source == null) {
            return null;
        }
        return StringUtils.indexOf(source, prefix, suffix, fromIndex, source.length());
    }

    public static Pair<Integer, Integer> indexOf(CharSequence source, CharSequence prefix, CharSequence suffix, int fromIndex, int endIndex) {
        if (source == null || prefix == null || suffix == null) {
            return null;
        }
        int begin = StringUtils.indexOf(source, prefix, fromIndex, endIndex);
        if (begin == -1) {
            return null;
        }
        int prefixLength = prefix.length();
        int end = StringUtils.indexOf(source, suffix, begin + prefixLength, endIndex);
        if (end == -1) {
            return null;
        }
        int suffixLength = suffix.length();
        int tempBegin = begin;
        int tempEnd = end;
        block0: while (true) {
            int index;
            int nestingLevel = 0;
            while ((index = StringUtils.indexOf(source, prefix, tempBegin + prefixLength, tempEnd)) != -1) {
                ++nestingLevel;
                tempBegin = index;
            }
            if (nestingLevel == 0) break;
            int i = 0;
            while (true) {
                if (i >= nestingLevel) continue block0;
                if ((tempEnd = StringUtils.indexOf(source, suffix, tempEnd + suffixLength, endIndex)) == -1) {
                    return null;
                }
                ++i;
            }
            break;
        }
        return new Pair<Integer, Integer>(begin, tempEnd);
    }

    public static int indexOf(CharSequence source, CharSequence target, int fromIndex) {
        if (source == null) {
            return -1;
        }
        return StringUtils.indexOf(source, target, fromIndex, source.length());
    }

    public static int indexOf(CharSequence source, CharSequence target, int fromIndex, int endIndex) {
        if (source == null || target == null) {
            return -1;
        }
        int index = StringUtils.indexOf(source, fromIndex, endIndex - fromIndex, target, 0, target.length(), 0);
        return index == -1 ? -1 : index + fromIndex;
    }

    public static int indexOf(CharSequence source, int sourceOffset, int sourceCount, CharSequence target, int targetOffset, int targetCount, int fromIndex) {
        if (source == null || target == null) {
            return -1;
        }
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = target.charAt(targetOffset);
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (source.charAt(i) != first) {
                while (++i <= max && source.charAt(i) != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && source.charAt(j) == target.charAt(k)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    public static boolean isAllEmpty(CharSequence ... charSequences) {
        if (charSequences == null || charSequences.length == 0) {
            return true;
        }
        for (CharSequence charSequence : charSequences) {
            if (!StringUtils.isNotEmpty(charSequence)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllEmpty(Object ... values) {
        if (values == null || values.length == 0) {
            return true;
        }
        for (Object value : values) {
            if (!StringUtils.isNotEmpty(value)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyEmpty(CharSequence ... values) {
        if (values == null || values.length == 0) {
            return true;
        }
        for (CharSequence s : values) {
            if (!StringUtils.isEmpty(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnyEmpty(Object ... values) {
        if (values == null || values.length == 0) {
            return true;
        }
        for (Object s : values) {
            if (!StringUtils.isEmpty(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }

    public static boolean isEmpty(CharSequence value) {
        return value == null || value.length() == 0;
    }

    public static boolean isEmpty(Object value) {
        return value == null || "".equals(value);
    }

    public static boolean isNotEmpty(CharSequence value) {
        return !StringUtils.isEmpty(value);
    }

    public static boolean isNotEmpty(Object value) {
        return !StringUtils.isEmpty(value);
    }

    public static int lastIndexOf(char[] source, char[] target) {
        if (source == null) {
            return -1;
        }
        return StringUtils.lastIndexOf(source, target, source.length);
    }

    public static int lastIndexOf(char[] source, char[] target, int fromIndex) {
        return StringUtils.lastIndexOf(source, target, fromIndex, 0);
    }

    public static int lastIndexOf(char[] source, char[] target, int fromIndex, int endIndex) {
        if (source == null || target == null) {
            return -1;
        }
        int sourceCount = Math.min(fromIndex, source.length) - endIndex;
        int index = StringUtils.lastIndexOf(source, endIndex, sourceCount, target, 0, target.length, sourceCount);
        return index == -1 ? -1 : index + endIndex;
    }

    public static int lastIndexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        int start;
        if (source == null || target == null) {
            return -1;
        }
        int rightIndex = sourceCount - targetCount;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        int strLastIndex = targetOffset + targetCount - 1;
        char strLastChar = target[strLastIndex];
        int min = sourceOffset + targetCount - 1;
        int i = min + fromIndex;
        block0: while (true) {
            if (i >= min && source[i] != strLastChar) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetCount - 1);
            int k = strLastIndex - 1;
            while (j > start) {
                if (source[j--] == target[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start - sourceOffset + 1;
    }

    public static int lastIndexOf(CharSequence source, CharSequence target) {
        if (source == null || target == null) {
            return -1;
        }
        return StringUtils.lastIndexOf(source, target, source.length());
    }

    public static int lastIndexOf(CharSequence source, CharSequence target, int fromIndex) {
        return StringUtils.lastIndexOf(source, target, fromIndex, 0);
    }

    public static int lastIndexOf(CharSequence source, CharSequence target, int fromIndex, int endIndex) {
        if (source == null || target == null) {
            return -1;
        }
        int sourceCount = Math.min(fromIndex, source.length()) - endIndex;
        int index = StringUtils.lastIndexOf(source, endIndex, sourceCount, target, 0, target.length(), sourceCount);
        return index == -1 ? -1 : index + endIndex;
    }

    public static int lastIndexOf(CharSequence source, int sourceOffset, int sourceCount, CharSequence target, int targetOffset, int targetCount, int fromIndex) {
        int start;
        if (source == null || target == null) {
            return -1;
        }
        int rightIndex = sourceCount - targetCount;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        int strLastIndex = targetOffset + targetCount - 1;
        char strLastChar = target.charAt(strLastIndex);
        int min = sourceOffset + targetCount - 1;
        int i = min + fromIndex;
        block0: while (true) {
            if (i >= min && source.charAt(i) != strLastChar) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetCount - 1);
            int k = strLastIndex - 1;
            while (j > start) {
                if (source.charAt(j--) == target.charAt(k--)) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start - sourceOffset + 1;
    }

    public static char[] mergeCharArray(char[] ... chars) {
        StringBuilder sb = new StringBuilder();
        for (char[] cs : chars) {
            sb.append(cs);
        }
        return sb.toString().toCharArray();
    }

    public static String mergePaths(Collection<String> paths, @Nullable PlaceholderFormat placeholderFormat) {
        StringBuilder sb = new StringBuilder();
        for (String path : paths) {
            if (StringUtils.isEmpty(path)) continue;
            if (placeholderFormat != null) {
                path = placeholderFormat.replacePlaceholders(path);
            }
            path = StringUtils.cleanPath(path);
            if (sb.length() != 0 && !path.startsWith(FOLDER_SEPARATOR)) {
                sb.append(FOLDER_SEPARATOR);
            }
            sb.append(path);
        }
        return StringUtils.cleanPath(sb.toString());
    }

    public static String mergePaths(String ... paths) {
        return StringUtils.mergePaths(Arrays.asList(paths), null);
    }

    public static String[] mergeStringArrays(String[] array1, String[] array2) {
        if (ObjectUtils.isEmpty(array1)) {
            return array2;
        }
        if (ObjectUtils.isEmpty(array2)) {
            return array1;
        }
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(Arrays.asList(array1));
        for (String str : array2) {
            if (result.contains(str)) continue;
            result.add(str);
        }
        return StringUtils.toStringArray(result);
    }

    @Nullable
    public static Pair<String, String> parseKV(String text, String separator) {
        int index = text.indexOf(separator);
        if (index == -1) {
            return null;
        }
        return new Pair<String, String>(text.substring(0, index), text.substring(index + separator.length()));
    }

    public static boolean pathEquals(String path1, String path2) {
        return StringUtils.cleanPath(path1).equals(StringUtils.cleanPath(path2));
    }

    public static String quote(String str) {
        return str != null ? "'" + str + "'" : null;
    }

    public static Object quoteIfString(Object obj) {
        return obj instanceof String ? StringUtils.quote((String)obj) : obj;
    }

    public static String removeChar(String text, char remove) {
        int len = text.length();
        if (len == 0) {
            return text;
        }
        char[] cs = new char[len];
        int index = 0;
        for (int i = 0; i < len; ++i) {
            char v = text.charAt(i);
            if (v == remove) continue;
            cs[index++] = v;
        }
        return new String(cs, 0, index);
    }

    public static String[] removeDuplicateStrings(String[] array) {
        if (ObjectUtils.isEmpty(array)) {
            return array;
        }
        TreeSet<String> set = new TreeSet<String>();
        for (String element : array) {
            set.add(element);
        }
        return StringUtils.toStringArray(set);
    }

    public static void replace(char[] chars, char replace, char newChar) {
        if (ArrayUtils.isEmpty(chars)) {
            return;
        }
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != replace) continue;
            chars[i] = newChar;
        }
    }

    public static String replace(String text, char replace, char newChar) {
        if (StringUtils.isEmpty(text)) {
            return text;
        }
        char[] chars = text.toCharArray();
        StringUtils.replace(chars, replace, newChar);
        return new String(chars);
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (StringUtils.isEmpty(inString) || StringUtils.isEmpty(oldPattern) || newPattern == null) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int index = inString.indexOf(oldPattern);
        int patLen = oldPattern.length();
        while (index >= 0) {
            sb.append(inString.substring(pos, index));
            sb.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sb.append(inString.substring(pos));
        return sb.toString();
    }

    public static String reversed(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        return new String(StringUtils.reversedCharArray(str.toCharArray()));
    }

    public static char[] reversedCharArray(char[] array) {
        if (array == null) {
            return array;
        }
        char[] newArray = new char[array.length];
        int index = 0;
        int i = newArray.length - 1;
        while (i >= 0) {
            newArray[index] = array[i];
            --i;
            ++index;
        }
        return newArray;
    }

    public static String[] sortStringArray(String[] array) {
        if (ObjectUtils.isEmpty(array)) {
            return EMPTY_ARRAY;
        }
        Arrays.sort(array);
        return array;
    }

    public static Stream<CharSequenceSplitSegment> split(CharSequence charSequence) {
        return StringUtils.split(charSequence, DEFAULT_SEPARATOR);
    }

    public static Stream<CharSequenceSplitSegment> split(CharSequence charSequence, boolean trimTokens, boolean ignoreEmptyTokens, CharSequence ... filters) {
        return StringUtils.split(charSequence, filters).map(s -> trimTokens ? (s == null ? s : s.trim()) : s).filter(s -> ignoreEmptyTokens ? StringUtils.isNotEmpty(s) : true);
    }

    public static Stream<CharSequenceSplitSegment> split(CharSequence charSequence, CharSequence ... filters) {
        if (charSequence == null) {
            return XUtils.emptyStream();
        }
        return StringUtils.split(charSequence, 0, charSequence.length(), Arrays.asList(filters));
    }

    public static Stream<CharSequenceSplitSegment> split(CharSequence charSequence, Collection<? extends CharSequence> filters) {
        if (charSequence == null) {
            return XUtils.emptyStream();
        }
        return StringUtils.split(charSequence, 0, charSequence.length(), filters);
    }

    public static Stream<CharSequenceSplitSegment> split(CharSequence charSequence, int beginIndex, int endIndex, Collection<? extends CharSequence> filters) {
        if (StringUtils.isEmpty(charSequence)) {
            return XUtils.emptyStream();
        }
        boolean find = false;
        for (CharSequence charSequence2 : filters) {
            if (StringUtils.indexOf(charSequence, charSequence2, beginIndex, endIndex) == -1) continue;
            find = true;
            break;
        }
        if (!find) {
            return Arrays.asList(new CharSequenceSplitSegment(charSequence)).stream();
        }
        return XUtils.stream(new CharSequenceSplitIterator(charSequence, filters, beginIndex, endIndex));
    }

    public static String[] splitToArray(CharSequence charSequence) {
        return StringUtils.splitToArray(charSequence, DEFAULT_SEPARATOR);
    }

    public static String[] splitToArray(CharSequence charSequence, boolean trimTokens, boolean ignoreEmptyTokens, CharSequence ... filters) {
        return (String[])StringUtils.split(charSequence, trimTokens, ignoreEmptyTokens, filters).map(s -> s == null ? null : s.toString()).toArray(String[]::new);
    }

    public static String[] splitToArray(CharSequence charSequence, CharSequence ... filters) {
        return StringUtils.splitToArray(charSequence, true, true, filters);
    }

    public static boolean startsWith(String text, String prefix, boolean ignoreCase) {
        return StringUtils.startsWith(text, prefix, 0, ignoreCase);
    }

    public static boolean startsWith(String text, String prefix, int toOffset, boolean ignoreCase) {
        if (ignoreCase) {
            int to = toOffset;
            int po = 0;
            int pc = prefix.length();
            if (toOffset < 0 || toOffset > text.length() - pc) {
                return false;
            }
            while (--pc >= 0) {
                if (Character.toLowerCase(text.charAt(to++)) == Character.toLowerCase(prefix.charAt(po++))) continue;
                return false;
            }
            return true;
        }
        return text.startsWith(prefix);
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        if (str == null || prefix == null) {
            return false;
        }
        if (str.startsWith(prefix)) {
            return true;
        }
        if (str.length() < prefix.length()) {
            return false;
        }
        String lcStr = str.substring(0, prefix.length()).toLowerCase();
        String lcPrefix = prefix.toLowerCase();
        return lcStr.equals(lcPrefix);
    }

    public static String stripFilenameExtension(String path) {
        if (path == null) {
            return null;
        }
        int extIndex = path.lastIndexOf(46);
        if (extIndex == -1) {
            return path;
        }
        int folderIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        if (folderIndex > extIndex) {
            return path;
        }
        return path.substring(0, extIndex);
    }

    public static boolean substringMatch(CharSequence str, int index, CharSequence substring) {
        for (int j = 0; j < substring.length(); ++j) {
            int i = index + j;
            if (i < str.length() && str.charAt(i) == substring.charAt(j)) continue;
            return false;
        }
        return true;
    }

    public static Stream<String> tokenize(String text, String delimiters) {
        if (StringUtils.isEmpty(text)) {
            return XUtils.emptyStream();
        }
        return StringUtils.tokenize(new StringTokenizer(text, delimiters));
    }

    public static Stream<String> tokenize(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        return StringUtils.tokenize(str, delimiters).map(s -> trimTokens ? (s == null ? s : s.trim()) : s).filter(s -> ignoreEmptyTokens ? StringUtils.isNotEmpty(s) : true);
    }

    public static Stream<String> tokenize(final StringTokenizer tokenizer) {
        if (tokenizer == null) {
            return XUtils.emptyStream();
        }
        Iterator<String> iterator = new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return tokenizer.hasMoreTokens();
            }

            @Override
            public String next() {
                return tokenizer.nextToken();
            }
        };
        return XUtils.stream(iterator);
    }

    public static String[] tokenizeToArray(String str, String delimiters) {
        return StringUtils.tokenizeToArray(str, delimiters, true, true);
    }

    public static String[] tokenizeToArray(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        return (String[])StringUtils.tokenize(str, delimiters, trimTokens, ignoreEmptyTokens).toArray(String[]::new);
    }

    public static String toLowerCase(String text, int begin, int end) {
        char[] chars = text.toCharArray();
        for (int i = begin; i < end; ++i) {
            chars[i] = Character.toLowerCase(chars[i]);
        }
        return new String(chars);
    }

    public static String toString(Object value, Object defaultValue) {
        return StringUtils.toString(value, defaultValue, true);
    }

    public static String toString(Object value, Object defaultValue, boolean checkLength) {
        String v;
        if (value == null) {
            return defaultValue == null ? null : defaultValue.toString();
        }
        String string = v = value instanceof String ? (String)value : value.toString();
        if (checkLength && StringUtils.isEmpty(v)) {
            return defaultValue.toString();
        }
        return v;
    }

    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }

    public static String[] toStringArray(Enumeration<String> enumeration) {
        if (enumeration == null) {
            return null;
        }
        ArrayList<String> list = Collections.list(enumeration);
        return list.toArray(new String[list.size()]);
    }

    public static String toUpperCase(String text, int begin, int end) {
        char[] chars = text.toCharArray();
        for (int i = begin; i < end; ++i) {
            chars[i] = Character.toUpperCase(chars[i]);
        }
        return new String(chars);
    }

    public static String transferredMeaning(String text, char ... chars) {
        if (StringUtils.isEmpty(text)) {
            return text;
        }
        int len = text.length();
        char[] values = new char[len * 2];
        int vIndex = 0;
        for (int index = 0; index < len; ++index) {
            char v = text.charAt(index);
            for (char c : chars) {
                if (c != v) continue;
                values[vIndex++] = 92;
                break;
            }
            values[vIndex++] = v;
        }
        return new String(values, 0, vIndex);
    }

    public static CharSequence trimAllWhitespace(CharSequence charSequence) {
        if (StringUtils.isEmpty(charSequence)) {
            return charSequence;
        }
        StringBuilder sb = new StringBuilder(charSequence);
        int index = 0;
        while (sb.length() > index) {
            if (Character.isWhitespace(sb.charAt(index))) {
                sb.deleteCharAt(index);
                continue;
            }
            ++index;
        }
        return sb;
    }

    public static String trimAllWhitespace(String charSequence) {
        if (charSequence == null) {
            return charSequence;
        }
        return StringUtils.trimAllWhitespace((CharSequence)charSequence).toString();
    }

    public static String[] trimArrayElements(String[] array) {
        if (ObjectUtils.isEmpty(array)) {
            return new String[0];
        }
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            String element = array[i];
            result[i] = element != null ? element.trim() : null;
        }
        return result;
    }

    public static CharSequence trimLeadingCharacter(CharSequence charSequence, char leadingCharacter) {
        if (StringUtils.isEmpty(charSequence)) {
            return charSequence;
        }
        StringBuilder sb = new StringBuilder(charSequence);
        while (sb.length() > 0 && sb.charAt(0) == leadingCharacter) {
            sb.deleteCharAt(0);
        }
        return sb;
    }

    public static String trimLeadingCharacter(String charSequence, char leadingCharacter) {
        if (charSequence == null) {
            return charSequence;
        }
        return StringUtils.trimLeadingCharacter((CharSequence)charSequence, leadingCharacter).toString();
    }

    public static CharSequence trimLeadingWhitespace(CharSequence charSequence) {
        if (StringUtils.isEmpty(charSequence)) {
            return charSequence;
        }
        StringBuilder sb = new StringBuilder(charSequence);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        return sb;
    }

    public static String trimLeadingWhitespace(String charSequence) {
        if (charSequence == null) {
            return charSequence;
        }
        return StringUtils.trimLeadingWhitespace((CharSequence)charSequence).toString();
    }

    public static CharSequence trimTrailingCharacter(CharSequence charSequence, char trailingCharacter) {
        if (StringUtils.isEmpty(charSequence)) {
            return charSequence;
        }
        StringBuilder sb = new StringBuilder(charSequence);
        while (sb.length() > 0 && sb.charAt(sb.length() - 1) == trailingCharacter) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb;
    }

    public static String trimTrailingCharacter(String charSequence, char trailingCharacter) {
        if (charSequence == null) {
            return charSequence;
        }
        return StringUtils.trimTrailingCharacter((CharSequence)charSequence, trailingCharacter).toString();
    }

    public static CharSequence trimTrailingWhitespace(CharSequence charSequence) {
        if (StringUtils.isEmpty(charSequence)) {
            return charSequence;
        }
        StringBuilder sb = new StringBuilder(charSequence);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb;
    }

    public static String trimTrailingWhitespace(String charSequence) {
        if (charSequence == null) {
            return charSequence;
        }
        return StringUtils.trimTrailingWhitespace((CharSequence)charSequence).toString();
    }

    public static CharSequence trimWhitespace(CharSequence charSequence) {
        if (StringUtils.isEmpty(charSequence)) {
            return charSequence;
        }
        StringBuilder sb = new StringBuilder(charSequence);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb;
    }

    public static String trimWhitespace(String charSequence) {
        if (charSequence == null) {
            return charSequence;
        }
        return StringUtils.trimWhitespace((CharSequence)charSequence).toString();
    }

    public static String uncapitalize(String str) {
        return StringUtils.changeFirstCharacterCase(str, false);
    }

    public static String unqualify(String qualifiedName) {
        return StringUtils.unqualify(qualifiedName, '.');
    }

    public static String unqualify(String qualifiedName, char separator) {
        return qualifiedName.substring(qualifiedName.lastIndexOf(separator) + 1);
    }

    private StringUtils() {
    }
}

