/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.Assert;
import io.basc.framework.util.InheriterDecorator;

public final class ThreadLocalInheriter<T>
extends InheriterDecorator<T, T> {
    private final ThreadLocal<T> threadLocal;
    private boolean nullable;

    public ThreadLocalInheriter(ThreadLocal<T> threadLocal) {
        this(threadLocal, false);
    }

    public ThreadLocalInheriter(ThreadLocal<T> threadLocal, boolean nullable) {
        Assert.requiredArgument(threadLocal != null, "threadLocal");
        this.threadLocal = threadLocal;
        this.nullable = nullable;
    }

    public void set(T value) {
        if (!this.nullable && value == null) {
            this.threadLocal.remove();
        } else {
            this.threadLocal.set(value);
        }
    }

    @Override
    public T capture() {
        return this.threadLocal.get();
    }

    @Override
    public T replay(T capture) {
        T backup = this.threadLocal.get();
        this.set(capture);
        return backup;
    }

    @Override
    public void restore(T backup) {
        this.set(backup);
    }

    @Override
    public T clear() {
        T backup = this.threadLocal.get();
        this.threadLocal.remove();
        return backup;
    }

    public String toString() {
        return this.threadLocal.toString();
    }

    public int hashCode() {
        return this.threadLocal.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof ThreadLocalInheriter) {
            ThreadLocalInheriter inheriter = (ThreadLocalInheriter)obj;
            return this.threadLocal.equals(inheriter.threadLocal);
        }
        return false;
    }
}

