/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.CollectionUtils;
import io.basc.framework.util.RandomUtils;
import io.basc.framework.util.Selector;
import io.basc.framework.util.Weighted;
import java.util.List;

public class WeightedRandomSelector<E>
implements Selector<E> {
    private static final WeightedRandomSelector<?> SINGLETON = new WeightedRandomSelector();

    @Override
    public E apply(List<E> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return (E)RandomUtils.random(list, e -> e instanceof Weighted ? ((Weighted)e).getWeight() : 1, null);
    }

    public static <T> WeightedRandomSelector<T> getSingleton() {
        return SINGLETON;
    }
}

