/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.io.FileUtils;
import io.basc.framework.lang.Nullable;
import io.basc.framework.util.Decorator;
import io.basc.framework.util.Named;
import io.basc.framework.util.RunnableProcessor;
import io.basc.framework.util.StringUtils;
import io.basc.framework.util.concurrent.ThreadPerTaskExecutor;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class XUtils {
    private static final boolean ENABLE_COMMON_POOL = ForkJoinPool.getCommonPoolParallelism() > 1;
    private static final Executor COMMON_EXECUTOR = ENABLE_COMMON_POOL ? ForkJoinPool.commonPool() : new ThreadPerTaskExecutor();

    private XUtils() {
    }

    public static boolean isEnableCommonPool() {
        return ENABLE_COMMON_POOL;
    }

    public static Executor getCommonExecutor() {
        return COMMON_EXECUTOR;
    }

    public static String getUUID() {
        return StringUtils.removeChar(UUID.randomUUID().toString(), '-');
    }

    @Nullable
    public static <T> T getDelegate(Object wrapper, Class<T> targetType) {
        if (targetType.isInstance(wrapper)) {
            return (T)wrapper;
        }
        if (wrapper instanceof Decorator) {
            return ((Decorator)wrapper).getDelegate(targetType);
        }
        return null;
    }

    public static String getName(Object instance, String defaultName) {
        if (instance == null) {
            return defaultName;
        }
        if (instance instanceof Named) {
            String name = ((Named)instance).getName();
            return name == null ? defaultName : name;
        }
        return defaultName;
    }

    public static String getRuntimeDirectory(ClassLoader classLoader) {
        URL url = classLoader.getResource("");
        return url == null ? FileUtils.getUserDir() : url.getPath();
    }

    public static String getWebAppDirectory(ClassLoader classLoader) {
        File webapp;
        String path = XUtils.getRuntimeDirectory(classLoader);
        File file = new File(path);
        if (file.isFile()) {
            return null;
        }
        if (!file.getName().equals("classes")) {
            return path;
        }
        for (int i = 0; i < 2; ++i) {
            if ((file = file.getParentFile()) == null) {
                return path;
            }
            if (!file.getName().equals("WEB-INF") || file.getParent() == null) continue;
            return file.getParent();
        }
        if (file != null && (webapp = new File(file, "/src/main/webapp")).exists()) {
            return webapp.getPath();
        }
        return path;
    }

    public static String getClassPath() {
        return System.getProperty("java.class.path");
    }

    public static String getPathSeparator() {
        return System.getProperty("path.separator");
    }

    public static String[] getClassPathArray() {
        String classPath = XUtils.getClassPath();
        if (StringUtils.isEmpty(classPath)) {
            return null;
        }
        return StringUtils.splitToArray((CharSequence)classPath, XUtils.getPathSeparator());
    }

    public static String getOSName() {
        return System.getProperty("os.name");
    }

    public static <T> Stream<T> stream(Iterator<? extends T> iterator) {
        Spliterator<? extends T> spliterator = Spliterators.spliteratorUnknownSize(iterator, 0);
        return StreamSupport.stream(spliterator, false);
    }

    public static Object toString(Supplier<String> supplier) {
        return new StringObject(supplier);
    }

    @SafeVarargs
    public static <T> T find(Predicate<? super T> predicate, T ... option) {
        if (option == null) {
            return null;
        }
        for (T o : option) {
            if (!predicate.test(o)) continue;
            return o;
        }
        return null;
    }

    public static <E extends Throwable> RunnableProcessor<E> composeWithExceptions(RunnableProcessor<? extends E> a, RunnableProcessor<? extends E> b) {
        return () -> {
            try {
                a.process();
            }
            catch (Throwable e1) {
                try {
                    b.process();
                }
                catch (Throwable e2) {
                    try {
                        e1.addSuppressed(e2);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                throw e1;
            }
            b.process();
        };
    }

    public static <T> Stream<T> emptyStream() {
        List list = Collections.emptyList();
        return list.stream();
    }

    private static class StringObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Supplier<String> msg;

        public StringObject(Supplier<String> msg) {
            this.msg = msg;
        }

        public String toString() {
            return this.msg.get();
        }
    }
}

