/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util.attribute;

import io.basc.framework.util.Assert;
import io.basc.framework.util.ObjectUtils;
import io.basc.framework.util.attribute.Attributes;
import io.basc.framework.util.attribute.EditableAttributes;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;

public class SerializableAttributes<K, V>
implements EditableAttributes<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<K, V> attrbitues;

    public SerializableAttributes() {
    }

    public SerializableAttributes(Map<K, V> attrbitues) {
        Assert.requiredArgument(attrbitues != null, "attrbitues");
        this.attrbitues = attrbitues;
    }

    public SerializableAttributes(Attributes<K, V> attributes) {
        this();
        Assert.requiredArgument(this.attrbitues != null, "attrbitues");
        Enumeration<K> enumeration = attributes.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            K key = enumeration.nextElement();
            this.setAttribute(key, attributes.getAttribute(key));
        }
    }

    @Override
    public V getAttribute(K name) {
        return this.attrbitues == null ? null : (V)this.attrbitues.get(name);
    }

    @Override
    public Enumeration<K> getAttributeNames() {
        if (this.attrbitues == null) {
            return Collections.emptyEnumeration();
        }
        return Collections.enumeration(this.attrbitues.keySet());
    }

    @Override
    public void setAttribute(K name, V value) {
        if (this.attrbitues == null) {
            this.attrbitues = new LinkedHashMap(8);
        }
        this.attrbitues.put(name, value);
    }

    @Override
    public void removeAttribute(K name) {
        if (this.attrbitues == null) {
            return;
        }
        this.attrbitues.remove(name);
    }

    public void clear() {
        if (this.attrbitues != null) {
            this.attrbitues.clear();
        }
    }

    public int hashCode() {
        if (this.attrbitues == null) {
            return 0;
        }
        return this.attrbitues.hashCode();
    }

    public String toString() {
        return this.attrbitues == null ? "{}" : this.attrbitues.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof SerializableAttributes) {
            return ObjectUtils.equals(this.attrbitues, ((SerializableAttributes)obj).attrbitues);
        }
        return false;
    }
}

