/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util.attribute;

import io.basc.framework.util.ObjectUtils;
import io.basc.framework.util.attribute.EditableAttributes;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;

public class SimpleAttributes<K, V>
implements EditableAttributes<K, V> {
    private Map<K, V> attributeMap;

    public SimpleAttributes() {
    }

    public SimpleAttributes(Map<K, V> attributeMap) {
        this.attributeMap = attributeMap;
    }

    @Override
    public V getAttribute(K name) {
        return this.attributeMap == null ? null : (V)this.attributeMap.get(name);
    }

    @Override
    public Enumeration<K> getAttributeNames() {
        return this.attributeMap == null ? Collections.emptyEnumeration() : Collections.enumeration(this.attributeMap.keySet());
    }

    @Override
    public void setAttribute(K name, V o) {
        if (this.attributeMap == null) {
            this.attributeMap = new LinkedHashMap(8);
        }
        this.attributeMap.put(name, o);
    }

    @Override
    public void removeAttribute(K name) {
        if (this.attributeMap == null) {
            return;
        }
        this.attributeMap.remove(name);
    }

    public void clear() {
        if (this.attributeMap != null) {
            this.attributeMap.clear();
        }
    }

    public String toString() {
        return this.attributeMap == null ? "{}" : this.attributeMap.toString();
    }

    public int hashCode() {
        return this.attributeMap == null ? 0 : this.attributeMap.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof SimpleAttributes) {
            return ObjectUtils.equals(this.attributeMap, ((SimpleAttributes)obj).attributeMap);
        }
        return false;
    }
}

