/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util.comparator;

import io.basc.framework.util.Assert;
import io.basc.framework.util.comparator.ComparableComparator;
import java.util.Comparator;

public class NullSafeComparator<T>
implements Comparator<T> {
    public static final NullSafeComparator NULLS_LOW = new NullSafeComparator(true);
    public static final NullSafeComparator NULLS_HIGH = new NullSafeComparator(false);
    private final Comparator<T> nonNullComparator;
    private final boolean nullsLow;

    private NullSafeComparator(boolean nullsLow) {
        this.nonNullComparator = new ComparableComparator();
        this.nullsLow = nullsLow;
    }

    public NullSafeComparator(Comparator<T> comparator, boolean nullsLow) {
        Assert.notNull(comparator, "The non-null comparator is required");
        this.nonNullComparator = comparator;
        this.nullsLow = nullsLow;
    }

    @Override
    public int compare(T o1, T o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return this.nullsLow ? -1 : 1;
        }
        if (o2 == null) {
            return this.nullsLow ? 1 : -1;
        }
        return this.nonNullComparator.compare(o1, o2);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NullSafeComparator)) {
            return false;
        }
        NullSafeComparator other = (NullSafeComparator)obj;
        return this.nonNullComparator.equals(other.nonNullComparator) && this.nullsLow == other.nullsLow;
    }

    public int hashCode() {
        return (this.nullsLow ? -1 : 1) * this.nonNullComparator.hashCode();
    }

    public String toString() {
        return "NullSafeComparator: non-null comparator [" + this.nonNullComparator + "]; " + (this.nullsLow ? "nulls low" : "nulls high");
    }
}

