/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util.concurrent;

import io.basc.framework.util.concurrent.ListenableFuture;
import io.basc.framework.util.concurrent.ListenableFutureTask;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;

public interface AsyncExecutor
extends Executor {
    @Override
    default public void execute(Runnable command) throws RejectedExecutionException {
        this.submit(command);
    }

    default public Future<?> submit(Runnable task) throws RejectedExecutionException {
        return this.submit(Executors.callable(task, null));
    }

    public <V> Future<V> submit(Callable<V> var1) throws RejectedExecutionException;

    default public ListenableFuture<?> submitListenable(Runnable task) throws RejectedExecutionException {
        ListenableFutureTask<Object> future = new ListenableFutureTask<Object>(task, null);
        this.submit(future);
        return future;
    }

    default public <V> ListenableFuture<V> submitListenable(Callable<V> task) throws RejectedExecutionException {
        ListenableFutureTask<V> future = new ListenableFutureTask<V>(task);
        this.submit(future);
        return future;
    }
}

