/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util.concurrent;

import io.basc.framework.util.concurrent.FailureCallback;
import io.basc.framework.util.concurrent.ListenableFuture;
import io.basc.framework.util.concurrent.ListenableFutureCallback;
import io.basc.framework.util.concurrent.ListenableFutureCallbackRegistry;
import io.basc.framework.util.concurrent.SuccessCallback;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

public class ListenableFutureTask<T>
extends FutureTask<T>
implements ListenableFuture<T> {
    private final ListenableFutureCallbackRegistry<T> callbacks = new ListenableFutureCallbackRegistry();

    public ListenableFutureTask(Callable<T> callable) {
        super(callable);
    }

    public ListenableFutureTask(Runnable runnable, T result) {
        super(runnable, result);
    }

    @Override
    public void addCallback(ListenableFutureCallback<? super T> callback) {
        this.callbacks.addCallback(callback);
    }

    @Override
    public void addCallback(SuccessCallback<? super T> successCallback, FailureCallback failureCallback) {
        if (successCallback != null) {
            this.callbacks.addSuccessCallback(successCallback);
        }
        if (failureCallback != null) {
            this.callbacks.addFailureCallback(failureCallback);
        }
    }

    @Override
    protected void done() {
        Throwable cause;
        try {
            Object result = this.get();
            this.callbacks.success(result);
            return;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (ExecutionException ex) {
            cause = ex.getCause();
            if (cause == null) {
                cause = ex;
            }
        }
        catch (Throwable ex) {
            cause = ex;
        }
        this.callbacks.failure(cause);
    }
}

