/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util.concurrent.support;

import io.basc.framework.util.Assert;
import io.basc.framework.util.concurrent.AsyncExecutor;
import io.basc.framework.util.concurrent.ListenableFuture;
import io.basc.framework.util.concurrent.ListenableFutureTask;
import io.basc.framework.util.concurrent.TaskDecorator;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;

public class TaskExecutorAdapter
implements AsyncExecutor {
    private final Executor concurrentExecutor;
    private TaskDecorator taskDecorator;

    public TaskExecutorAdapter(Executor concurrentExecutor) {
        Assert.notNull((Object)concurrentExecutor, "Executor must not be null");
        this.concurrentExecutor = concurrentExecutor;
    }

    public final void setTaskDecorator(TaskDecorator taskDecorator) {
        this.taskDecorator = taskDecorator;
    }

    @Override
    public void execute(Runnable task) {
        this.doExecute(this.concurrentExecutor, this.taskDecorator, task);
    }

    public void execute(Runnable task, long startTimeout) {
        this.execute(task);
    }

    @Override
    public Future<?> submit(Runnable task) {
        if (this.taskDecorator == null && this.concurrentExecutor instanceof ExecutorService) {
            return ((ExecutorService)this.concurrentExecutor).submit(task);
        }
        FutureTask<Object> future = new FutureTask<Object>(task, null);
        this.doExecute(this.concurrentExecutor, this.taskDecorator, future);
        return future;
    }

    public <T> Future<T> submit(Callable<T> task) {
        if (this.taskDecorator == null && this.concurrentExecutor instanceof ExecutorService) {
            return ((ExecutorService)this.concurrentExecutor).submit(task);
        }
        FutureTask<T> future = new FutureTask<T>(task);
        this.doExecute(this.concurrentExecutor, this.taskDecorator, future);
        return future;
    }

    @Override
    public ListenableFuture<?> submitListenable(Runnable task) {
        ListenableFutureTask<Object> future = new ListenableFutureTask<Object>(task, null);
        this.doExecute(this.concurrentExecutor, this.taskDecorator, future);
        return future;
    }

    public <T> ListenableFuture<T> submitListenable(Callable<T> task) {
        ListenableFutureTask<T> future = new ListenableFutureTask<T>(task);
        this.doExecute(this.concurrentExecutor, this.taskDecorator, future);
        return future;
    }

    protected void doExecute(Executor concurrentExecutor, TaskDecorator taskDecorator, Runnable runnable) throws RejectedExecutionException {
        concurrentExecutor.execute(taskDecorator != null ? taskDecorator.decorate(runnable) : runnable);
    }
}

