/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util.page;

import io.basc.framework.util.Cursor;
import io.basc.framework.util.page.Pageable;
import java.util.function.Function;

public class MapPageable<M extends Pageable<SK, ST>, SK, ST, K, T>
implements Pageable<K, T> {
    protected final M source;
    private final Function<? super SK, ? extends K> keyMap;
    private final Function<? super ST, ? extends T> valueMap;

    public MapPageable(M source, Function<? super SK, ? extends K> keyMap, Function<? super ST, ? extends T> valueMap) {
        this.source = source;
        this.keyMap = keyMap;
        this.valueMap = valueMap;
    }

    @Override
    public K getCursorId() {
        Object value = this.source.getCursorId();
        return value == null ? null : (K)this.keyMap.apply((SK)value);
    }

    @Override
    public K getNextCursorId() {
        Object value = this.source.getNextCursorId();
        return value == null ? null : (K)this.keyMap.apply((SK)value);
    }

    @Override
    public boolean hasNext() {
        return this.source.hasNext();
    }

    @Override
    public Cursor<T> iterator() {
        return this.source.iterator().map(this.valueMap);
    }
}

