/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util.page;

import io.basc.framework.util.Assert;
import io.basc.framework.util.Processor;
import io.basc.framework.util.page.InMemoryPaginations;
import io.basc.framework.util.page.Page;
import io.basc.framework.util.page.Pageable;
import io.basc.framework.util.page.Pageables;
import io.basc.framework.util.page.Pages;
import io.basc.framework.util.page.Pagination;
import io.basc.framework.util.page.Paginations;
import io.basc.framework.util.page.SharedPage;
import io.basc.framework.util.page.SharedPageable;
import io.basc.framework.util.page.SharedPageables;
import io.basc.framework.util.page.SharedPages;
import io.basc.framework.util.page.SharedPagination;
import io.basc.framework.util.page.SharedPaginations;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

public class PageSupport {
    private PageSupport() {
    }

    public static long getStart(long pageNumber, long limit) {
        Assert.isTrue(pageNumber > 0L, "required pageNumber > 0");
        Assert.isTrue(limit > 0L, "required limit > 0");
        return Math.max(0L, pageNumber - 1L) * limit;
    }

    public static long getPageNumber(long start, long limit) {
        Assert.isTrue(limit > 0L, "required limit > 0");
        Assert.isTrue(start >= 0L, "required start >= 0");
        return start / limit + 1L;
    }

    public static boolean hasMore(long total, long start, long limit) {
        Assert.isTrue(total >= 0L, "required total >= 0");
        Assert.isTrue(limit > 0L, "required limit > 0");
        Assert.isTrue(start >= 0L, "required start >= 0");
        return total - start <= limit;
    }

    public static long getPages(long total, long limit) {
        Assert.isTrue(total >= 0L, "required total >= 0");
        Assert.isTrue(limit > 0L, "required limit > 0");
        if (total <= limit || limit <= 0L) {
            return 1L;
        }
        return (long)Math.ceil((double)total / (double)limit);
    }

    public static long getNextStart(long start, long limit) {
        Assert.isTrue(limit > 0L, "required limit > 0");
        Assert.isTrue(start >= 0L, "required start >= 0");
        return Math.max(start, start + limit);
    }

    public static <T> Pagination<T> toPage(long total, long pageNumber, long limit, List<T> list) {
        return new SharedPagination<T>(PageSupport.getStart(pageNumber, limit), list, limit, total);
    }

    public static <K, T> Pageable<K, T> emptyPageable(K cursorId) {
        return new SharedPageable(cursorId);
    }

    public static <K, T> Pageables<K, T> emptyPageables(K cursorId) {
        return new SharedPageables<K, T>(PageSupport.emptyPageables(cursorId), null);
    }

    public static <K, T> Page<K, T> emptyPage(K cursorId, long count) {
        return new SharedPage(cursorId, Collections.emptyList(), count, 0L);
    }

    public static <K, T> Pages<K, T> emptyPages(K cursorId, Long count) {
        return new SharedPages<K, T>(PageSupport.emptyPage(cursorId, count), null);
    }

    public static <T> Pagination<T> emptyPagination(long start, long count) {
        return new SharedPagination(start, count);
    }

    public static <T> Paginations<T> emptyPaginations(long start, long count) {
        return new SharedPaginations(PageSupport.emptyPagination(start, count), null);
    }

    public static <K, T, V> Collection<? extends Callable<V>> toGroupTasks(Pageables<K, T> pageables, final Processor<? super Pageable<K, T>, ? extends V, ? extends Exception> processor) {
        return pageables.pages().map(e -> new Callable<V>((Pageables)e){
            final /* synthetic */ Pageables val$e;
            {
                this.val$e = pageables;
            }

            @Override
            public V call() throws Exception {
                return processor.process(this.val$e);
            }
        }).collect(Collectors.toList());
    }

    public static <T> Paginations<T> paging(List<T> list, int pageSize) {
        return new InMemoryPaginations<T>(list, 0, pageSize);
    }
}

