/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util.page;

import io.basc.framework.lang.Nullable;
import io.basc.framework.util.Cursor;
import io.basc.framework.util.ResultSet;
import io.basc.framework.util.page.MapPageable;
import io.basc.framework.util.page.SharedPageable;
import java.util.List;
import java.util.function.Function;

public interface Pageable<K, T>
extends ResultSet<T> {
    @Nullable
    public K getCursorId();

    @Nullable
    public K getNextCursorId();

    @Override
    public Cursor<T> iterator();

    default public List<T> getList() {
        return this.iterator().toList();
    }

    default public boolean hasNext() {
        return this.getNextCursorId() != null;
    }

    default public Pageable<K, T> shared() {
        return new SharedPageable(this);
    }

    default public <TT> Pageable<K, TT> map(Function<? super T, ? extends TT> map) {
        return this.map(Function.identity(), map);
    }

    default public <TK, TT> Pageable<TK, TT> map(Function<? super K, ? extends TK> keyMap, Function<? super T, ? extends TT> valueMap) {
        return new MapPageable<Pageable, K, T, TK, TT>(this, keyMap, valueMap);
    }
}

