/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util.page;

import io.basc.framework.util.Cursor;
import io.basc.framework.util.XUtils;
import io.basc.framework.util.page.AllPage;
import io.basc.framework.util.page.Page;
import io.basc.framework.util.page.Pageable;
import io.basc.framework.util.page.Pageables;
import io.basc.framework.util.page.PagesIterator;
import io.basc.framework.util.page.Paginations;
import io.basc.framework.util.page.SharedPages;
import io.basc.framework.util.page.StreamPaginations;
import java.util.stream.Stream;

public interface Pages<K, T>
extends Page<K, T>,
Pageables<K, T> {
    @Override
    default public Pages<K, T> next() {
        return this.jumpTo(this.getNextCursorId());
    }

    @Override
    default public Pages<K, T> jumpTo(K cursorId) {
        return this.jumpTo(cursorId, this.getCount());
    }

    @Override
    default public Pages<K, T> shared() {
        return new SharedPages(this);
    }

    @Override
    default public Stream<? extends Pages<K, T>> pages() {
        PagesIterator iterator = new PagesIterator(this);
        return XUtils.stream(iterator);
    }

    public Pages<K, T> jumpTo(K var1, long var2);

    @Override
    default public Pageable<K, T> all() {
        return new AllPage(this);
    }

    default public Paginations<T> toPaginations(long start, long limit) {
        return new StreamPaginations(this.getTotal(), (Long)start, limit, (s, count) -> Cursor.of(this.all()).limit((long)s, count));
    }
}

