/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util.page;

import io.basc.framework.lang.Nullable;
import io.basc.framework.util.page.Page;
import io.basc.framework.util.page.SharedPageable;
import java.util.List;

public class SharedPage<K, T>
extends SharedPageable<K, T>
implements Page<K, T> {
    private static final long serialVersionUID = 1L;
    private long total;
    private long count;

    public SharedPage() {
    }

    public SharedPage(K cursorId) {
        super(cursorId);
    }

    public SharedPage(K cursorId, long count) {
        this(cursorId, null, count, 0L);
    }

    public SharedPage(K cursorId, List<T> rows, long count, long total) {
        this(cursorId, rows, null, count, total);
    }

    public SharedPage(K cursorId, List<T> rows, @Nullable K nextCursorId, long count, long total) {
        super(cursorId, rows, nextCursorId);
        this.count = count;
        this.total = total;
    }

    public SharedPage(Page<K, T> page) {
        super(page);
        this.count = page.getCount();
        this.total = page.getTotal();
    }

    @Override
    public long getTotal() {
        return this.total;
    }

    @Override
    public void setList(List<T> list) {
        if (this.total == 0L) {
            this.total = list.size();
        }
        super.setList(list);
    }

    public void setTotal(long total) {
        this.total = total;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }
}

