/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util.page;

import io.basc.framework.util.Cursor;
import io.basc.framework.util.page.Page;
import io.basc.framework.util.page.Pageable;
import io.basc.framework.util.page.PageableProcessor;
import io.basc.framework.util.page.Pages;
import io.basc.framework.util.page.StreamPage;
import java.util.stream.Stream;

public class StreamPages<K, T>
implements Pages<K, T> {
    private final Page<K, T> page;
    protected final PageableProcessor<K, T> processor;

    public StreamPages(Page<K, T> page, PageableProcessor<K, T> processor) {
        this.page = page;
        this.processor = processor;
    }

    public StreamPages(long total, K cursorId, long count, PageableProcessor<K, T> processor) {
        Pageable pageable = processor.process(cursorId, count);
        this.page = new StreamPage(cursorId, () -> pageable.iterator(), pageable.getNextCursorId(), count, total);
        this.processor = processor;
    }

    public PageableProcessor<K, T> getProcessor() {
        return this.processor;
    }

    @Override
    public long getTotal() {
        return this.page.getTotal();
    }

    @Override
    public K getCursorId() {
        return this.page.getCursorId();
    }

    @Override
    public long getCount() {
        return this.page.getCount();
    }

    @Override
    public K getNextCursorId() {
        return this.page.getNextCursorId();
    }

    @Override
    public Cursor<T> iterator() {
        return this.page.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.page.hasNext();
    }

    @Override
    public Stream<T> stream() {
        return this.page.stream();
    }

    @Override
    public Pages<K, T> jumpTo(K cursorId, long count) {
        return new StreamPages<K, T>(this.getTotal(), cursorId, count, this.processor);
    }
}

