/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util.placeholder.support;

import io.basc.framework.util.Assert;
import io.basc.framework.util.StringUtils;
import io.basc.framework.util.placeholder.PlaceholderReplacer;
import io.basc.framework.util.placeholder.PlaceholderResolver;

public class SimplePlaceholderReplaer
implements PlaceholderReplacer {
    public static final PlaceholderReplacer STRICT_REPLACER = new SimplePlaceholderReplaer("${", "}", false);
    public static final PlaceholderReplacer NON_STRICT_REPLACER = new SimplePlaceholderReplaer("${", "}", true);
    private final char[] prefix;
    private final char[] suffix;
    private final boolean ignoreUnresolvablePlaceholders;

    public SimplePlaceholderReplaer(String prefix, String suffix, boolean ignoreUnresolvablePlaceholders) {
        Assert.hasLength(prefix);
        Assert.hasLength(suffix);
        this.prefix = prefix.toCharArray();
        this.suffix = suffix.toCharArray();
        this.ignoreUnresolvablePlaceholders = ignoreUnresolvablePlaceholders;
    }

    public char[] getPrefix() {
        return this.prefix;
    }

    public char[] getSuffix() {
        return this.suffix;
    }

    public String replacePlaceholders(String text, PlaceholderResolver placeholderResolver, boolean ignoreUnresolvablePlaceholders) {
        if (StringUtils.isEmpty(text)) {
            return text;
        }
        char[] chars = text.toCharArray();
        StringBuilder sb = new StringBuilder(chars.length * 2);
        int begin = 0;
        while (begin < chars.length) {
            if (this.prefixEq(chars, begin)) {
                int tempBegin = begin;
                begin += this.prefix.length;
                String value = null;
                while (begin < chars.length) {
                    if (this.suffixEq(chars, begin)) {
                        String placeholder = new String(chars, tempBegin + this.prefix.length, begin - tempBegin - this.prefix.length);
                        value = placeholderResolver.resolvePlaceholder(placeholder);
                        if (value == null && !ignoreUnresolvablePlaceholders) {
                            throw new IllegalArgumentException("Could not resolve placeholder '" + placeholder + "' in string value \"" + text + "\"");
                        }
                        begin += this.suffix.length;
                        break;
                    }
                    ++begin;
                }
                if (value == null) {
                    sb.append(chars, tempBegin, begin - tempBegin);
                    continue;
                }
                sb.append(value);
                continue;
            }
            sb.append(chars[begin]);
            ++begin;
        }
        return sb.toString();
    }

    @Override
    public String replacePlaceholders(String value, PlaceholderResolver placeholderResolver) {
        return this.replacePlaceholders(value, placeholderResolver, this.ignoreUnresolvablePlaceholders);
    }

    @Override
    public String replaceRequiredPlaceholders(String value, PlaceholderResolver placeholderResolver) throws IllegalArgumentException {
        return this.replacePlaceholders(value, placeholderResolver, false);
    }

    private boolean prefixEq(char[] chars, int begin) {
        int v = 0;
        int i = begin;
        while (i < begin + this.prefix.length) {
            if (i >= chars.length || chars[i] != this.prefix[v]) {
                return false;
            }
            ++i;
            ++v;
        }
        return true;
    }

    private boolean suffixEq(char[] chars, int begin) {
        int v = 0;
        int i = begin;
        while (i < begin + this.suffix.length) {
            if (i >= chars.length || chars[i] != this.suffix[v]) {
                return false;
            }
            ++i;
            ++v;
        }
        return true;
    }
}

