/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.value;

import io.basc.framework.convert.ConversionException;
import io.basc.framework.convert.ConversionFailedException;
import io.basc.framework.convert.ConversionService;
import io.basc.framework.convert.Converter;
import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.convert.lang.StringConverter;
import io.basc.framework.env.Sys;
import io.basc.framework.json.JsonSupport;
import io.basc.framework.json.JsonUtils;
import io.basc.framework.util.ObjectUtils;
import io.basc.framework.util.StringUtils;
import io.basc.framework.value.Value;
import java.lang.reflect.Array;
import java.util.Objects;

public class AnyValue
implements Value,
Cloneable {
    private Converter<? super Object, ? super Object, ? extends RuntimeException> converter;
    private JsonSupport jsonSupport;
    private TypeDescriptor typeDescriptor;
    private Object value;
    private StringConverter stringConverter;

    public AnyValue(Object value) {
        this(value, null, null);
    }

    public AnyValue(Object value, Converter<? super Object, ? super Object, ? extends RuntimeException> converter) {
        this(value, null, converter);
    }

    public AnyValue(Object value, TypeDescriptor type) {
        this(value, type, null);
    }

    public AnyValue(Object value, TypeDescriptor type, Converter<? super Object, ? super Object, ? extends RuntimeException> converter) {
        this.setValue(value, type);
        this.setConverter(converter);
    }

    @Override
    public StringConverter getStringConverter() {
        return this.stringConverter == null ? Value.super.getStringConverter() : this.stringConverter;
    }

    public void setStringConverter(StringConverter stringConverter) {
        this.stringConverter = stringConverter;
    }

    public AnyValue clone() {
        AnyValue value = new AnyValue(this.value, this.typeDescriptor, this.converter);
        value.jsonSupport = this.jsonSupport;
        value.stringConverter = this.stringConverter;
        return value;
    }

    @Override
    public boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (this.converter != null) {
            if (this.converter instanceof ConversionService) {
                return ((ConversionService)this.converter).canConvert(sourceType, targetType);
            }
            return Value.super.canConvert(sourceType, targetType);
        }
        return !Value.class.isAssignableFrom(sourceType.getType()) && Value.super.canConvert(sourceType, targetType);
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) throws ConversionException {
        if (this.isSupportAsArray(sourceType) && targetType.isArray()) {
            return this.getAsArray(targetType.getElementTypeDescriptor());
        }
        Converter<? super Object, ? super Object, ? extends RuntimeException> converter = this.getConverter();
        if (converter instanceof ConversionService && !((ConversionService)converter).canConvert(sourceType, targetType)) {
            return this.convertInternal(source, sourceType, targetType, null);
        }
        try {
            return converter.convert(source, sourceType, targetType);
        }
        catch (ConversionException e) {
            return this.convertInternal(source, sourceType, targetType, e);
        }
    }

    private Object convertInternal(Object source, TypeDescriptor sourceType, TypeDescriptor targetType, ConversionException exception) {
        if (source instanceof String) {
            return this.getJsonSupport().convert(source, sourceType, targetType);
        }
        if (Value.isBaseType(targetType.getType())) {
            return this.getAsObject(targetType.getType());
        }
        throw new ConversionFailedException(sourceType, targetType, source, exception);
    }

    public boolean equals(Object obj) {
        if (this.value == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof AnyValue) {
            return ObjectUtils.equals(this.value, ((AnyValue)obj).get());
        }
        return false;
    }

    public <E> E[] getAsArray(Class<E> componentType) {
        return this.getAsArray(TypeDescriptor.valueOf(componentType));
    }

    public <E> E[] getAsArray(TypeDescriptor componentType) {
        String[] values = this.split(this.getAsString());
        if (values == null) {
            return null;
        }
        Object array = Array.newInstance(componentType.getType(), values.length);
        for (int i = 0; i < values.length; ++i) {
            AnyValue value = this.clone();
            value.setValue(values[i]);
            if (!value.isPresent()) continue;
            Array.set(array, i, value.getAsObject(componentType));
        }
        return (Object[])array;
    }

    public Converter<? super Object, ? super Object, ? extends RuntimeException> getConverter() {
        return this.converter == null ? Sys.getEnv().getConversionService() : this.converter;
    }

    public JsonSupport getJsonSupport() {
        return this.jsonSupport == null ? JsonUtils.getSupport() : this.jsonSupport;
    }

    @Override
    public Object getSource() {
        return this.value;
    }

    @Override
    public TypeDescriptor getTypeDescriptor() {
        if (this.typeDescriptor != null) {
            return this.typeDescriptor;
        }
        return Value.super.getTypeDescriptor();
    }

    public int hashCode() {
        return this.value == null ? super.hashCode() : this.value.hashCode();
    }

    public boolean isSupportAsArray(TypeDescriptor type) {
        if (type == null) {
            return false;
        }
        return type.getType() == String.class;
    }

    public void setConverter(Converter<? super Object, ? super Object, ? extends RuntimeException> converter) {
        this.converter = converter;
    }

    public void setJsonSupport(JsonSupport jsonSupport) {
        this.jsonSupport = jsonSupport;
    }

    public void setValue(Object value) {
        this.setValue(value, null);
    }

    public void setValue(Object value, TypeDescriptor type) {
        this.value = value;
        this.typeDescriptor = type;
    }

    public String[] split(String value) {
        return StringUtils.splitToArray(value);
    }

    public String toString() {
        return Objects.toString(this.value);
    }

    @Override
    public Value transform(Object value, TypeDescriptor type) {
        AnyValue anyValue = this.clone();
        anyValue.setValue(value, type);
        return anyValue;
    }
}

