/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.value;

import io.basc.framework.util.Assert;
import io.basc.framework.util.Pair;
import io.basc.framework.util.StringMatcher;
import io.basc.framework.util.StringMatchers;
import io.basc.framework.value.Value;
import io.basc.framework.value.ValueFactory;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface PropertyFactory
extends ValueFactory<String>,
Iterable<String> {
    default public boolean containsKey(String key) {
        Value value = this.get(key);
        return value != null && value.isPresent();
    }

    @Override
    public Iterator<String> iterator();

    default public Stream<String> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public Stream<String> stream(String pattern, StringMatcher keyMatcher) {
        Assert.requiredArgument(pattern != null, "pattern");
        Assert.requiredArgument(keyMatcher != null, "keyMatcher");
        return this.stream().filter(t -> StringMatchers.match(keyMatcher, pattern, t));
    }

    default public Stream<Pair<String, Value>> streamByPrefix(String prefix) {
        Assert.requiredArgument(prefix != null, "prefix");
        return this.stream().filter(k -> k.length() > prefix.length() && k.startsWith(prefix)).map(k -> new Pair<String, Value>(k.substring(prefix.length()), this.get(k)));
    }
}

