/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.value;

import io.basc.framework.convert.ConversionService;
import io.basc.framework.convert.Converter;
import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.convert.lang.StringConverter;
import io.basc.framework.core.ResolvableType;
import io.basc.framework.lang.Nullable;
import io.basc.framework.util.Assert;
import io.basc.framework.util.ClassUtils;
import io.basc.framework.util.ObjectUtils;
import io.basc.framework.util.Optional;
import io.basc.framework.util.Source;
import io.basc.framework.value.AnyValue;
import io.basc.framework.value.EmptyValue;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.NoSuchElementException;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;

public interface Value
extends Optional<Value>,
IntSupplier,
LongSupplier,
DoubleSupplier,
ConversionService {
    public static final Value EMPTY = new EmptyValue();
    public static final Value[] EMPTY_ARRAY = new Value[0];

    public static boolean isBaseType(Type type) {
        Class clazz;
        if (type == null) {
            return false;
        }
        if (type instanceof Class && (clazz = (Class)type).isEnum()) {
            return true;
        }
        return ClassUtils.isPrimitiveOrWrapper(type) || type == String.class || type == BigDecimal.class || type == BigInteger.class || Number.class == type || type == Class.class;
    }

    public static Value of(@Nullable Object value) {
        return Value.of(value, null, null);
    }

    public static Value of(@Nullable Object value, @Nullable TypeDescriptor type) {
        return Value.of(value, type, null);
    }

    public static Value of(@Nullable Object value, @Nullable Converter<? super Object, ? super Object, ? extends RuntimeException> converter) {
        return Value.of(value, null, converter);
    }

    public static Value of(@Nullable Object value, @Nullable TypeDescriptor type, @Nullable Converter<? super Object, ? super Object, ? extends RuntimeException> converter) {
        if (converter == null) {
            if (type == null) {
                if (value == null) {
                    return EMPTY;
                }
                if (value instanceof Value) {
                    return (Value)value;
                }
                return new AnyValue(value);
            }
            return new AnyValue(value, type);
        }
        return new AnyValue(value, type, converter);
    }

    default public <T> Optional<T> as(Class<? extends T> type) {
        return this.map(e -> this.getAsObject(type));
    }

    @Override
    default public boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return !Value.isBaseType(targetType.getType());
    }

    @Nullable
    default public <T, E extends Throwable> T convert(Class<? extends T> targetType, Converter<? super Object, ? extends Object, E> converter) throws E {
        return (T)this.convert(TypeDescriptor.valueOf(targetType), converter);
    }

    @Nullable
    default public <E extends Throwable> Object convert(TypeDescriptor targetType, Converter<? super Object, ? extends Object, E> converter) throws E {
        Assert.requiredArgument(converter != null, "converter");
        Object value = this.getSource();
        if (value == null) {
            return null;
        }
        Class<?> rawClass = targetType.getType();
        if (rawClass == Object.class || rawClass == null) {
            return value;
        }
        TypeDescriptor sourceType = this.getTypeDescriptor();
        if (converter instanceof ConversionService) {
            ConversionService conversionService = (ConversionService)converter;
            if (conversionService.canConvert(sourceType, targetType)) {
                return converter.convert(value, sourceType, targetType);
            }
            if (value instanceof Value) {
                value = ((Value)value).getSource();
                sourceType = ((Value)value).getTypeDescriptor();
            }
        }
        value = this.getSource();
        sourceType = this.getTypeDescriptor();
        try {
            return converter.convert(value, sourceType, targetType);
        }
        catch (RuntimeException e) {
            if (value instanceof Value) {
                return ((Value)value).getAsObject(targetType);
            }
            throw e;
        }
    }

    @Override
    default public Value get() {
        Object value = this.getSource();
        if (value == null) {
            throw new NoSuchElementException("No value present");
        }
        if (value instanceof Value) {
            return (Value)value;
        }
        return this.transform(value, this.getTypeDescriptor());
    }

    default public StringConverter getStringConverter() {
        return StringConverter.DEFAULT;
    }

    @Nullable
    default public BigDecimal getAsBigDecimal() {
        Object value = this.getSource();
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        if (value instanceof Number) {
            return new BigDecimal(((Number)value).doubleValue());
        }
        if (value instanceof Value) {
            return ((Value)value).getAsBigDecimal();
        }
        return this.getStringConverter().convert(this.getAsString(), BigDecimal.class);
    }

    @Nullable
    default public BigInteger getAsBigInteger() {
        Object value = this.getSource();
        if (value == null) {
            return null;
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toBigInteger();
        }
        if (value instanceof Value) {
            return ((Value)value).getAsBigInteger();
        }
        return this.getStringConverter().convert(this.getAsString(), BigInteger.class);
    }

    default public boolean getAsBoolean() {
        Object value = this.getSource();
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() == 1;
        }
        if (value instanceof Value) {
            return ((Value)value).getAsBoolean();
        }
        return this.getStringConverter().convert(this.getAsString(), Boolean.TYPE);
    }

    default public byte getAsByte() {
        Object value = this.getSource();
        if (value == null) {
            return 0;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof Value) {
            return ((Value)value).getAsByte();
        }
        return this.getStringConverter().convert(this.getAsString(), Byte.TYPE);
    }

    default public char getAsChar() {
        Object value = this.getSource();
        if (value == null) {
            return '\u0000';
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof Value) {
            return ((Value)value).getAsChar();
        }
        return this.getStringConverter().convert(this.getAsString(), Character.TYPE).charValue();
    }

    @Nullable
    default public Class<?> getAsClass() {
        Object value = this.getSource();
        if (value == null) {
            return null;
        }
        if (value instanceof Class) {
            return (Class)value;
        }
        if (value instanceof Value) {
            return ((Value)value).getAsClass();
        }
        return this.getStringConverter().convert(this.getAsString(), Class.class);
    }

    @Override
    default public double getAsDouble() {
        Object value = this.getSource();
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Value) {
            return ((Value)value).getAsDouble();
        }
        return this.getStringConverter().convert(this.getAsString(), Double.TYPE);
    }

    @Nullable
    default public Enum<?> getAsEnum(Class<?> enumType) {
        Object value = this.getSource();
        if (value == null) {
            return null;
        }
        if (value instanceof Enum) {
            return (Enum)value;
        }
        if (value instanceof Value) {
            return ((Value)value).getAsEnum(enumType);
        }
        return (Enum)this.getStringConverter().convert(this.getAsString(), enumType);
    }

    default public float getAsFloat() {
        Object value = this.getSource();
        if (value == null) {
            return 0.0f;
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        if (value instanceof Value) {
            return ((Value)value).getAsFloat();
        }
        return this.getStringConverter().convert(this.getAsString(), Float.TYPE).floatValue();
    }

    @Override
    default public int getAsInt() {
        Object value = this.getSource();
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof Value) {
            return ((Value)value).getAsInt();
        }
        return this.getStringConverter().convert(this.getAsString(), Integer.TYPE);
    }

    @Override
    default public long getAsLong() {
        Object value = this.getSource();
        if (value == null) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof Value) {
            return ((Value)value).getAsLong();
        }
        return this.getStringConverter().convert(this.getAsString(), Long.TYPE);
    }

    @Nullable
    default public Number getAsNumber() {
        Object value = this.getSource();
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        if (value instanceof Value) {
            return ((Value)value).getAsNumber();
        }
        return this.getStringConverter().convert(this.getAsString(), Number.class);
    }

    @Nullable
    default public <T> T getAsObject(Class<? extends T> type) {
        Object v = null;
        v = String.class == type ? this.getAsString() : (Integer.TYPE == type ? Integer.valueOf(this.getAsInt()) : (Integer.class == type ? (this.isEmpty() ? null : Integer.valueOf(this.getAsInt())) : (Long.TYPE == type ? Long.valueOf(this.getAsLong()) : (Long.class == type ? (this.isEmpty() ? null : Long.valueOf(this.getAsLong())) : (Float.TYPE == type ? Float.valueOf(this.getAsFloat()) : (Float.class == type ? (this.isEmpty() ? null : Float.valueOf(this.getAsFloat())) : (Double.TYPE == type ? Double.valueOf(this.getAsDouble()) : (Double.class == type ? (this.isEmpty() ? null : Double.valueOf(this.getAsDouble())) : (Short.TYPE == type ? Short.valueOf(this.getAsShort()) : (Short.class == type ? (this.isEmpty() ? null : Short.valueOf(this.getAsShort())) : (Boolean.TYPE == type ? Boolean.valueOf(this.getAsBoolean()) : (Boolean.class == type ? (this.isEmpty() ? null : Boolean.valueOf(this.getAsBoolean())) : (Byte.TYPE == type ? Byte.valueOf(this.getAsByte()) : (Byte.class == type ? (this.isEmpty() ? null : Byte.valueOf(this.getAsByte())) : (Character.TYPE == type ? Character.valueOf(this.getAsChar()) : (Character.class == type ? (this.isEmpty() ? null : Character.valueOf(this.getAsChar())) : (BigDecimal.class == type ? this.getAsBigDecimal() : (BigInteger.class == type ? this.getAsBigInteger() : (Number.class == type ? this.getAsNumber() : (Class.class == type ? this.getAsClass() : (type.isEnum() ? this.getAsEnum(type) : (type == Value.class ? this : this.getAsObject(TypeDescriptor.valueOf(type))))))))))))))))))))))));
        return (T)v;
    }

    @Nullable
    default public Object getAsObject(Type type) {
        if (type instanceof Class) {
            return this.getAsObject((Class)type);
        }
        return this.getAsObject(TypeDescriptor.valueOf(type));
    }

    default public Object getAsObject(ResolvableType type) {
        return this.getAsObject(TypeDescriptor.valueOf(type));
    }

    @Nullable
    default public Object getAsObject(TypeDescriptor type) {
        if (Value.isBaseType(type.getType())) {
            return this.getAsObject(type.getType());
        }
        Object value = this.getSource();
        if (value == null) {
            return null;
        }
        Class<?> rawClass = type.getType();
        if (rawClass == Object.class || rawClass == null) {
            return value;
        }
        if (!type.isGeneric() && type.getType().isInstance(value)) {
            return value;
        }
        TypeDescriptor sourceType = this.getTypeDescriptor();
        if (this.canConvert(sourceType, type)) {
            return this.convert(value, sourceType, type);
        }
        if (value instanceof Value) {
            Value sourceValue = (Value)value;
            if (sourceValue.canConvert(sourceType, type)) {
                return sourceValue.convert(value, sourceType, type);
            }
            value = sourceValue.getSource();
            sourceType = sourceValue.getTypeDescriptor();
        }
        value = this.getSource();
        sourceType = this.getTypeDescriptor();
        if (value instanceof Value) {
            return ((Value)value).getAsObject(type);
        }
        return this.convert(value, sourceType, type);
    }

    default public short getAsShort() {
        Object value = this.getSource();
        if (value == null) {
            return 0;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof Value) {
            return ((Value)value).getAsShort();
        }
        return this.getStringConverter().convert(this.getAsString(), Short.TYPE);
    }

    @Nullable
    default public String getAsString() {
        Object value = this.getSource();
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        if (value instanceof Value) {
            return ((Value)value).getAsString();
        }
        return this.convert(value, this.getTypeDescriptor(), String.class);
    }

    @Nullable
    public Object getSource();

    default public TypeDescriptor getTypeDescriptor() {
        Object value = this.getSource();
        if (value == null) {
            return TypeDescriptor.valueOf(Object.class);
        }
        return TypeDescriptor.forObject(value);
    }

    default public boolean isEmpty() {
        if (this.isPresent()) {
            Object value = this.getSource();
            if (value instanceof Value) {
                return ((Value)value).isEmpty();
            }
            return ObjectUtils.isEmpty(value);
        }
        return true;
    }

    default public boolean isNumber() {
        if (this.isEmpty()) {
            return false;
        }
        Object value = this.getSource();
        if (value instanceof Number) {
            return true;
        }
        if (value instanceof Value) {
            return ((Value)value).isNumber();
        }
        return this.getStringConverter().getStringToNumber().isNumeric(this.getAsString());
    }

    @Override
    default public boolean isPresent() {
        Object value = this.getSource();
        if (value == null) {
            return false;
        }
        if (value instanceof Value) {
            return ((Value)value).isPresent();
        }
        return true;
    }

    default public Value or(Object other) {
        return this.orElse(other instanceof Value ? (Value)other : this.transform(other, null));
    }

    default public <E extends Throwable> Value orGet(Source<? extends Object, ? extends E> other) throws E {
        return this.orElseGet(() -> this.transform(other.get(), null));
    }

    default public Value transform(Object value, @Nullable TypeDescriptor type) {
        return new AnyValue(value, type);
    }
}

