/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.value;

import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.util.Assert;
import io.basc.framework.util.Cursor;
import io.basc.framework.util.ResultSet;
import io.basc.framework.value.AnyValue;
import io.basc.framework.value.Value;
import java.util.Arrays;
import java.util.List;

public class Values
implements ResultSet<Value> {
    protected final ResultSet<Value> resultSet;

    public static Values of(Object ... args) {
        Assert.requiredArgument(args != null, "args");
        Value[] values = new Value[args.length];
        for (int i = 0; i < args.length; ++i) {
            values[i] = new AnyValue(args[i]);
        }
        return new Values(values);
    }

    public static Values of(TypeDescriptor[] typeDescriptors, Object[] args) {
        Assert.requiredArgument(typeDescriptors != null, "typeDescriptors");
        Assert.requiredArgument(args != null, "args");
        Assert.requiredArgument(typeDescriptors.length != args.length, "The number of parameters is inconsistent");
        Value[] values = new Value[typeDescriptors.length];
        for (int i = 0; i < typeDescriptors.length; ++i) {
            values[i] = new AnyValue(args[i], typeDescriptors[i]);
        }
        return new Values(values);
    }

    public Values(Value ... values) {
        Assert.requiredArgument(values != null, "values");
        this.resultSet = ResultSet.of(Arrays.asList(values));
    }

    public Values(ResultSet<Value> resultSet) {
        Assert.requiredArgument(resultSet != null, "resultSet");
        this.resultSet = resultSet;
    }

    @Override
    public Value first() {
        return (Value)this.resultSet.first();
    }

    @Override
    public Value last() {
        return (Value)this.resultSet.last();
    }

    @Override
    public List<Value> toList() {
        return this.resultSet.toList();
    }

    @Override
    public Object[] toArray() {
        List values = this.resultSet.toList();
        Object[] args = new Object[values.size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = ((Value)values.get(i)).getSource();
        }
        return args;
    }

    @Override
    public Cursor<Value> iterator() {
        return this.resultSet.iterator();
    }
}

