/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.value.support;

import io.basc.framework.event.ChangeEvent;
import io.basc.framework.event.EventListener;
import io.basc.framework.factory.Configurable;
import io.basc.framework.factory.ServiceLoaderFactory;
import io.basc.framework.lang.Nullable;
import io.basc.framework.util.Assert;
import io.basc.framework.util.Registration;
import io.basc.framework.value.ConfigurablePropertyFactory;
import io.basc.framework.value.PropertyFactories;
import io.basc.framework.value.PropertyFactory;
import io.basc.framework.value.PropertyWrapper;
import io.basc.framework.value.Value;
import io.basc.framework.value.support.DefaultValueFactory;
import io.basc.framework.value.support.ObservablePropertyFactory;
import java.util.Iterator;
import java.util.stream.Stream;

public class DefaultPropertyFactory
extends DefaultValueFactory<String, PropertyFactory>
implements ConfigurablePropertyFactory,
Configurable {
    private final PropertyWrapper propertyWrapper;
    private final PropertyFactories propertyFactories = new PropertyFactories();
    private final ObservablePropertyFactory observable;

    public DefaultPropertyFactory() {
        this((PropertyWrapper)null);
    }

    public DefaultPropertyFactory(@Nullable PropertyWrapper propertyWrapper) {
        this.propertyWrapper = propertyWrapper;
        this.observable = new ObservablePropertyFactory(propertyWrapper);
    }

    @Override
    public Iterator<String> iterator() {
        return this.stream().iterator();
    }

    public ObservablePropertyFactory getObservable() {
        return this.observable;
    }

    @Override
    public boolean isConfigured() {
        return this.propertyFactories.isConfigured();
    }

    public PropertyFactories getPropertyFactories() {
        return this.propertyFactories;
    }

    @Override
    public void configure(ServiceLoaderFactory serviceLoaderFactory) {
        this.propertyFactories.configure(serviceLoaderFactory);
    }

    @Override
    public Stream<String> stream() {
        Stream<Object> stream = super.keySet().stream();
        stream = Stream.concat(stream, this.propertyFactories.stream());
        return Stream.concat(stream, this.observable.stream()).distinct();
    }

    @Override
    public Value get(String key) {
        Object value = super.get(key);
        if (value != null && value.isPresent()) {
            return value;
        }
        value = this.propertyFactories.get(key);
        if (value != null && value.isPresent()) {
            return value;
        }
        value = this.observable.get(key);
        return value != null && value.isPresent() ? value : Value.EMPTY;
    }

    @Override
    public boolean containsKey(String key) {
        return super.containsKey(key) || this.propertyFactories.containsKey(key) || this.observable.containsKey(key);
    }

    @Override
    public Registration registerListener(String name, EventListener<ChangeEvent<String>> eventListener) {
        return super.registerListener(name, eventListener).and(this.propertyFactories.registerListener(name, eventListener)).and(this.observable.registerListener(name, eventListener));
    }

    @Override
    public void put(String key, Object value) {
        if (this.propertyWrapper == null) {
            super.put(key, value);
            return;
        }
        Assert.requiredArgument(key != null, "key");
        Assert.requiredArgument(value != null, "value");
        super.put(key, this.propertyWrapper.wrap(key, value));
    }

    @Override
    public boolean putIfAbsent(String key, Object value) {
        if (this.propertyWrapper == null) {
            return super.putIfAbsent(key, value);
        }
        Assert.requiredArgument(key != null, "key");
        Assert.requiredArgument(value != null, "value");
        return super.putIfAbsent(key, this.propertyWrapper.wrap(key, value));
    }
}

