/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.dto;

import io.camunda.tasklist.dto.SearchType;
import io.generated.tasklist.client.type.Sort;
import io.generated.tasklist.client.type.TaskOrderBy;
import io.generated.tasklist.client.type.TaskSortFields;
import java.util.ArrayList;
import java.util.List;

public class Pagination {
    private Integer pageSize;
    private List<String> search;
    private SearchType searchType;
    private List<TaskOrderBy> sort;

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Pagination setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public List<String> getSearch() {
        return this.search;
    }

    public Pagination setSearch(List<String> search) {
        this.search = search;
        return this;
    }

    public SearchType getSearchType() {
        return this.searchType;
    }

    public Pagination setSearchType(SearchType searchType) {
        this.searchType = searchType;
        return this;
    }

    public List<TaskOrderBy> getSort() {
        return this.sort;
    }

    public Pagination setSort(List<TaskOrderBy> sort) {
        this.sort = sort;
        return this;
    }

    public static class Builder {
        private Integer pageSize;
        private List<String> search;
        private SearchType searchType;
        private List<TaskOrderBy> sort;

        public Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder after(List<String> search) {
            this.search = search;
            this.searchType = SearchType.AFTER;
            return this;
        }

        public Builder before(List<String> search) {
            this.search = search;
            this.searchType = SearchType.BEFORE;
            return this;
        }

        public Builder afterOrEqual(List<String> search) {
            this.search = search;
            this.searchType = SearchType.AFTER_OR_EQUAL;
            return this;
        }

        public Builder sortBy(TaskSortFields field, Sort order) {
            if (this.sort == null) {
                this.sort = new ArrayList<TaskOrderBy>();
            }
            this.sort.add(new TaskOrderBy(field, order));
            return this;
        }

        public Pagination build() {
            return new Pagination().setPageSize(this.pageSize).setSearch(this.search).setSearchType(this.searchType).setSort(this.sort);
        }
    }
}

