/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.camunda.common.auth.Product;
import io.camunda.tasklist.CamundaTaskListClientBuilder;
import io.camunda.tasklist.CamundaTaskListClientProperties;
import io.camunda.tasklist.dto.DateFilter;
import io.camunda.tasklist.dto.Form;
import io.camunda.tasklist.dto.Pagination;
import io.camunda.tasklist.dto.SearchType;
import io.camunda.tasklist.dto.Task;
import io.camunda.tasklist.dto.TaskList;
import io.camunda.tasklist.dto.TaskSearch;
import io.camunda.tasklist.dto.TaskState;
import io.camunda.tasklist.dto.Variable;
import io.camunda.tasklist.exception.TaskListException;
import io.camunda.tasklist.generated.api.FormApi;
import io.camunda.tasklist.generated.api.TaskApi;
import io.camunda.tasklist.generated.api.VariablesApi;
import io.camunda.tasklist.generated.invoker.ApiClient;
import io.camunda.tasklist.generated.invoker.ApiException;
import io.camunda.tasklist.generated.invoker.Configuration;
import io.camunda.tasklist.generated.model.IncludeVariable;
import io.camunda.tasklist.generated.model.TaskAssignRequest;
import io.camunda.tasklist.generated.model.TaskByVariables;
import io.camunda.tasklist.generated.model.TaskCompleteRequest;
import io.camunda.tasklist.generated.model.TaskSearchRequest;
import io.camunda.tasklist.generated.model.VariableInputDTO;
import io.camunda.tasklist.generated.model.VariablesSearchRequest;
import io.camunda.tasklist.util.ConverterUtils;
import io.camunda.tasklist.util.JwtUtils;
import io.camunda.zeebe.client.ZeebeClient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

public class CamundaTaskListClient {
    private final ApiClient apiClient = Configuration.getDefaultApiClient();
    private final ZeebeClient zeebeClient;
    private final CamundaTaskListClientProperties properties;
    private TaskApi taskApi;
    private FormApi formApi;
    private VariablesApi variablesApi;
    private long tokenExpiration;

    protected CamundaTaskListClient(CamundaTaskListClientProperties properties, ZeebeClient zeebeClient) throws TaskListException {
        assert (properties != null) : "properties must not be null";
        assert (properties.getTaskListUrl() != null) : "taskListUrl must not be null";
        assert (properties.getAuthentication() != null) : "authentication must not be null";
        assert (!properties.isUseZeebeUserTasks() || zeebeClient != null) : "zeebeClient must not be null";
        this.properties = properties;
        this.apiClient.updateBaseUri(properties.getTaskListUrl());
        this.zeebeClient = zeebeClient;
        this.authenticate();
    }

    public static CamundaTaskListClientBuilder builder() {
        return new CamundaTaskListClientBuilder();
    }

    public Task unclaim(String taskId) throws TaskListException {
        try {
            this.reconnectEventually();
            return ConverterUtils.toTask(this.taskApi.unassignTask(taskId), null);
        }
        catch (TaskListException | ApiException e) {
            throw new TaskListException("Error unclaiming task " + taskId, e);
        }
    }

    public Task claim(String taskId, String assignee) throws TaskListException {
        return this.claim(taskId, assignee, false);
    }

    public Task claim(String taskId, String assignee, Boolean allowOverrideAssignment) throws TaskListException {
        try {
            this.reconnectEventually();
            return ConverterUtils.toTask(this.taskApi.assignTask(taskId, new TaskAssignRequest().assignee(assignee).allowOverrideAssignment(allowOverrideAssignment)), null);
        }
        catch (TaskListException | ApiException e) {
            throw new TaskListException("Error assigning task " + taskId, e);
        }
    }

    public void completeTask(String taskId, Map<String, Object> variablesMap) throws TaskListException {
        try {
            Task task = this.getTask(taskId);
            if (task.getImplementation().equals((Object)Task.Implementation.JOB_WORKER)) {
                this.reconnectEventually();
                List<VariableInputDTO> variables = ConverterUtils.toVariableInput(variablesMap);
                this.taskApi.completeTask(taskId, new TaskCompleteRequest().variables(variables));
            } else if (task.getImplementation().equals((Object)Task.Implementation.ZEEBE_USER_TASK)) {
                if (this.zeebeClient == null) {
                    throw new IllegalStateException("zeebeClient must not be null, please set useZeebeUserTasks to assert this on startup");
                }
                this.zeebeClient.newUserTaskCompleteCommand(Long.parseLong(taskId)).variables(variablesMap).send().join();
            }
        }
        catch (TaskListException | ApiException e) {
            throw new TaskListException("Error assigning task " + taskId, e);
        }
    }

    public TaskList getTasks(Boolean assigned, TaskState state, Integer pageSize) throws TaskListException {
        return this.getTasks(new TaskSearch().setAssigned(assigned).setState(state).setPagination(this.createPagination(pageSize)));
    }

    public TaskList getTasks(Boolean assigned, TaskState state, Pagination pagination) throws TaskListException {
        return this.getTasks(new TaskSearch().setAssigned(assigned).setState(state).setPagination(pagination));
    }

    public TaskList getTasks(Boolean assigned, TaskState state, boolean withVariables, Integer pageSize) throws TaskListException {
        return this.getTasks(new TaskSearch().setAssigned(assigned).setState(state).setWithVariables(withVariables).setPagination(this.createPagination(pageSize)));
    }

    private Pagination createPagination(Integer pageSize) {
        return new Pagination().setPageSize(pageSize);
    }

    public TaskList getTasks(Boolean assigned, TaskState state, boolean withVariables, Pagination pagination) throws TaskListException {
        return this.getTasks(new TaskSearch().setAssigned(assigned).setState(state).setWithVariables(withVariables).setPagination(pagination));
    }

    public TaskList getAssigneeTasks(String assigneeId, TaskState state, Integer pageSize) throws TaskListException {
        return this.getTasks(new TaskSearch().setAssignee(assigneeId).setState(state).setPagination(this.createPagination(pageSize)));
    }

    public TaskList getAssigneeTasks(String assigneeId, TaskState state, Pagination pagination) throws TaskListException {
        return this.getTasks(new TaskSearch().setAssignee(assigneeId).setState(state).setWithVariables(this.properties.isDefaultShouldReturnVariables()).setPagination(pagination));
    }

    public TaskList getAssigneeTasks(String assigneeId, TaskState state, boolean withVariables, Integer pageSize) throws TaskListException {
        return this.getTasks(new TaskSearch().setAssigned(true).setAssignee(assigneeId).setState(state).setWithVariables(withVariables).setPagination(this.createPagination(pageSize)));
    }

    public TaskList getAssigneeTasks(String assigneeId, TaskState state, boolean withVariables, Pagination pagination) throws TaskListException {
        return this.getTasks(new TaskSearch().setAssignee(assigneeId).setState(state).setWithVariables(withVariables).setPagination(pagination));
    }

    public TaskList getGroupTasks(String group, TaskState state, Integer pageSize) throws TaskListException {
        return this.getTasks(new TaskSearch().setCandidateGroup(group).setState(state).setPagination(this.createPagination(pageSize)));
    }

    public TaskList getGroupTasks(String group, TaskState state, Pagination pagination) throws TaskListException {
        return this.getTasks(new TaskSearch().setCandidateGroup(group).setState(state).setPagination(pagination));
    }

    public TaskList getGroupTasks(String group, TaskState state, boolean withVariables, Integer pageSize) throws TaskListException {
        return this.getTasks(new TaskSearch().setCandidateGroup(group).setState(state).setWithVariables(withVariables).setPagination(this.createPagination(pageSize)));
    }

    public TaskList getGroupTasks(String group, TaskState state, boolean withVariables, Pagination pagination) throws TaskListException {
        return this.getTasks(new TaskSearch().setCandidateGroup(group).setState(state).setWithVariables(withVariables).setPagination(pagination));
    }

    public TaskList getGroupsTasks(List<String> groups, TaskState state, boolean withVariables, Pagination pagination) throws TaskListException {
        return this.getTasks(new TaskSearch().setCandidateGroups(groups).setState(state).setWithVariables(withVariables).setPagination(pagination));
    }

    public Task getTask(String taskId) throws TaskListException {
        return this.getTask(taskId, this.properties.isDefaultShouldReturnVariables());
    }

    public Task getTask(String taskId, boolean withVariables) throws TaskListException {
        try {
            this.reconnectEventually();
            List<Variable> variables = null;
            if (withVariables) {
                variables = this.getVariables(taskId);
            }
            return ConverterUtils.toTask(this.taskApi.getTaskById(taskId), variables);
        }
        catch (TaskListException | ApiException e) {
            throw new TaskListException("Error reading task " + taskId, e);
        }
    }

    public List<Variable> getVariables(String taskId) throws TaskListException {
        try {
            this.reconnectEventually();
            return this.taskApi.searchTaskVariables(taskId, new VariablesSearchRequest()).stream().map(vsr -> {
                if (Boolean.TRUE.equals(vsr.getIsValueTruncated())) {
                    try {
                        return this.getVariable(vsr.getId());
                    }
                    catch (TaskListException e) {
                        throw new RuntimeException("Error while loading full value of variable", e);
                    }
                }
                try {
                    return ConverterUtils.improveVariable(vsr);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException("Error while improving variable", e);
                }
            }).collect(Collectors.toList());
        }
        catch (ApiException | RuntimeException e) {
            throw new TaskListException("Error reading task " + taskId, e);
        }
    }

    public Variable getVariable(String variableId) throws TaskListException {
        try {
            this.reconnectEventually();
            return ConverterUtils.toVariable(this.variablesApi.getVariableById(variableId));
        }
        catch (JsonProcessingException | ApiException e) {
            throw new TaskListException("Error while loading variable " + variableId, (Exception)e);
        }
    }

    public Form getForm(String formId, String processDefinitionId) throws TaskListException {
        return this.getForm(formId, processDefinitionId, null);
    }

    public Form getForm(String formId, String processDefinitionId, Long version) throws TaskListException {
        try {
            if (formId.startsWith("camunda-forms:bpmn:")) {
                formId = formId.substring("camunda-forms:bpmn:".length());
            }
            return ConverterUtils.toForm(this.formApi.getForm(formId, processDefinitionId, version));
        }
        catch (ApiException e) {
            throw new TaskListException("Error reading form " + formId, e);
        }
    }

    public TaskList before(TaskList taskList) throws TaskListException {
        return this.paginate(taskList, SearchType.BEFORE);
    }

    public TaskList beforeOrEquals(TaskList taskList) throws TaskListException {
        return this.paginate(taskList, SearchType.BEFORE_OR_EQUAL);
    }

    public TaskList after(TaskList taskList) throws TaskListException {
        return this.paginate(taskList, SearchType.AFTER);
    }

    public TaskList afterOrEqual(TaskList taskList) throws TaskListException {
        return this.paginate(taskList, SearchType.AFTER_OR_EQUAL);
    }

    private TaskList paginate(TaskList taskList, SearchType direction) throws TaskListException {
        if (taskList.getSearch().getPagination() == null || taskList.getSearch().getPagination().getPageSize() == null) {
            throw new TaskListException("Before/After/AfterOrEquals search are only possible if a pageSize is set");
        }
        if (taskList.getItems() == null || taskList.getItems().isEmpty()) {
            throw new TaskListException("Before/After/AfterOrEquals search are only possible if some items are present");
        }
        TaskSearch newSearch = new TaskSearch().setAssigned(taskList.getSearch().getAssigned()).setAssignee(taskList.getSearch().getAssignee()).setCandidateGroup(taskList.getSearch().getCandidateGroup()).setState(taskList.getSearch().getState()).setWithVariables(taskList.getSearch().isWithVariables()).setPagination(this.getSearchPagination(taskList, direction));
        return this.getTasks(newSearch);
    }

    private Pagination getSearchPagination(TaskList taskList, SearchType type) {
        switch (type) {
            case BEFORE: {
                return new Pagination.Builder().pageSize(taskList.getSearch().getPagination().getPageSize()).before(taskList.first().getSortValues()).build();
            }
            case BEFORE_OR_EQUAL: {
                return new Pagination.Builder().pageSize(taskList.getSearch().getPagination().getPageSize()).beforeOrEqual(taskList.first().getSortValues()).build();
            }
            case AFTER: {
                return new Pagination.Builder().pageSize(taskList.getSearch().getPagination().getPageSize()).after(taskList.last().getSortValues()).build();
            }
        }
        return new Pagination.Builder().pageSize(taskList.getSearch().getPagination().getPageSize()).afterOrEqual(taskList.last().getSortValues()).build();
    }

    public TaskList getTasks(TaskSearch search) throws TaskListException {
        if (search.getWithVariables() == null) {
            search.setWithVariables(this.properties.isDefaultShouldReturnVariables());
        }
        Pagination pagination = search.getPagination();
        TaskSearchRequest request = ConverterUtils.toTaskSearchRequest(search);
        if (pagination != null) {
            if (pagination.getSearchType() != null && pagination.getSearch() != null && !pagination.getSearch().isEmpty()) {
                if (pagination.getSearchType().equals((Object)SearchType.BEFORE)) {
                    request.searchBefore(pagination.getSearch());
                } else if (pagination.getSearchType().equals((Object)SearchType.BEFORE_OR_EQUAL)) {
                    request.searchBeforeOrEqual(pagination.getSearch());
                } else if (pagination.getSearchType().equals((Object)SearchType.AFTER)) {
                    request.searchAfter(pagination.getSearch());
                } else if (pagination.getSearchType().equals((Object)SearchType.AFTER_OR_EQUAL)) {
                    request.searchAfterOrEqual(pagination.getSearch());
                }
            }
            request.pageSize(pagination.getPageSize());
            request.sort(pagination.getSort());
        }
        return new TaskList().setItems(this.getTasks(request, search.getWithVariables())).setSearch(search);
    }

    public TaskList getTasks(String group, Boolean assigned, String assigneeId, TaskState state, boolean withVariables, Pagination pagination) throws TaskListException {
        return this.getTasks(new TaskSearch().setCandidateGroup(group).setAssigned(assigned).setAssignee(assigneeId).setState(state).setWithVariables(withVariables).setPagination(pagination));
    }

    public TaskList getTasks(String candidateUser, List<String> candidateUsers, String group, List<String> groups, Boolean assigned, String assignee, TaskState state, DateFilter followUpDate, DateFilter dueDate, String processDefinitionId, String processInstanceId, String taskDefinitionId, List<TaskByVariables> taskVariables, List<String> tenantIds, List<IncludeVariable> includeVariables, boolean withVariables, Pagination pagination) throws TaskListException {
        return this.getTasks(new TaskSearch().setCandidateUser(candidateUser).setCandidateUsers(candidateUsers).setCandidateGroup(group).setCandidateGroups(groups).setAssigned(assigned).setAssignee(assignee).setState(state).setFollowUpDate(followUpDate).setDueDate(dueDate).setProcessDefinitionKey(processDefinitionId).setProcessInstanceKey(processInstanceId).setTaskDefinitionId(taskDefinitionId).setTaskVariables(taskVariables).setTenantIds(tenantIds).setIncludeVariables(includeVariables.stream().map(IncludeVariable::getName).collect(Collectors.toList())).setWithVariables(withVariables).setPagination(pagination));
    }

    public List<Task> getTasks(TaskSearchRequest search, boolean withVariables) throws TaskListException {
        try {
            this.reconnectEventually();
            List<Task> tasks = ConverterUtils.toTasks(this.taskApi.searchTasks(search));
            if (withVariables && (search.getIncludeVariables() == null || search.getIncludeVariables().isEmpty())) {
                this.loadVariables(tasks);
            }
            return tasks;
        }
        catch (ApiException e) {
            throw new TaskListException("Error searching tasks", e);
        }
    }

    public void loadVariables(List<Task> tasks) throws TaskListException {
        try {
            HashMap<String, CompletableFuture<List>> futures = new HashMap<String, CompletableFuture<List>>();
            HashMap<String, Task> taskMap = new HashMap<String, Task>();
            for (Task task : tasks) {
                taskMap.put(task.getId(), task);
                futures.put(task.getId(), CompletableFuture.supplyAsync(() -> {
                    try {
                        return this.getVariables(task.getId());
                    }
                    catch (TaskListException e) {
                        return null;
                    }
                }));
            }
            for (Map.Entry entry : futures.entrySet()) {
                ((Task)taskMap.get(entry.getKey())).setVariables((List)((Future)entry.getValue()).get());
            }
            futures.clear();
            taskMap.clear();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new TaskListException("Error loading task variables", e);
        }
    }

    public void setTokenExpiration(long tokenExpiration) {
        this.tokenExpiration = tokenExpiration;
    }

    private void reconnectEventually() throws TaskListException {
        if (this.properties.isAlwaysReconnect() || this.tokenExpiration > 0L && this.tokenExpiration < System.currentTimeMillis() - 1000L) {
            this.properties.getAuthentication().resetToken(Product.TASKLIST);
            this.authenticate();
        }
    }

    public void authenticate() throws TaskListException {
        Map.Entry header = this.properties.getAuthentication().getTokenHeader(Product.TASKLIST);
        if (((String)header.getValue()).startsWith("Bearer ")) {
            this.tokenExpiration = (long)JwtUtils.getExpiration(((String)header.getValue()).substring(7)) * 1000L;
        } else if (this.properties.getCookieExpiration() != null) {
            this.tokenExpiration = System.currentTimeMillis() + this.properties.getCookieExpiration().toMillis();
        }
        this.apiClient.setRequestInterceptor(builder -> builder.header((String)header.getKey(), (String)header.getValue()));
        this.taskApi = new TaskApi(this.apiClient);
        this.formApi = new FormApi(this.apiClient);
        this.variablesApi = new VariablesApi(this.apiClient);
    }
}

