/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.dto;

import io.camunda.tasklist.dto.DateFilter;
import io.camunda.tasklist.dto.Pagination;
import io.camunda.tasklist.dto.TaskState;
import io.camunda.tasklist.exception.TaskListException;
import io.camunda.tasklist.generated.model.IncludeVariable;
import io.camunda.tasklist.generated.model.TaskByVariables;
import io.camunda.tasklist.util.JsonUtils;
import java.util.ArrayList;
import java.util.List;

public class TaskSearch {
    private String candidateGroup;
    private List<String> candidateGroups;
    private String assignee;
    private String candidateUser;
    private List<String> candidateUsers;
    private Boolean assigned;
    private TaskState state;
    private String processDefinitionKey;
    private String processInstanceKey;
    private String taskDefinitionId;
    private List<TaskByVariables> taskVariables;
    private List<String> tenantIds;
    private Boolean withVariables;
    private DateFilter followUpDate;
    private DateFilter dueDate;
    private List<String> includeVariables;
    private Pagination pagination;

    public List<String> getCandidateGroups() {
        return this.candidateGroups;
    }

    public TaskSearch setCandidateGroups(List<String> candidateGroups) {
        this.candidateGroups = candidateGroups;
        return this;
    }

    public List<String> getCandidateUsers() {
        return this.candidateUsers;
    }

    public TaskSearch setCandidateUsers(List<String> candidateUsers) {
        this.candidateUsers = candidateUsers;
        return this;
    }

    public TaskSearch setWithVariables(Boolean withVariables) {
        this.withVariables = withVariables;
        return this;
    }

    public String getCandidateUser() {
        return this.candidateUser;
    }

    public TaskSearch setCandidateUser(String candidateUser) {
        this.candidateUser = candidateUser;
        return this;
    }

    public DateFilter getFollowUpDate() {
        return this.followUpDate;
    }

    public TaskSearch setFollowUpDate(DateFilter followUpDate) {
        this.followUpDate = followUpDate;
        return this;
    }

    public DateFilter getDueDate() {
        return this.dueDate;
    }

    public TaskSearch setDueDate(DateFilter dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    public String getCandidateGroup() {
        return this.candidateGroup;
    }

    public TaskSearch setCandidateGroup(String candidateGroup) {
        this.candidateGroup = candidateGroup;
        return this;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public TaskSearch setAssignee(String assignee) {
        this.assignee = assignee;
        return this;
    }

    public Boolean getAssigned() {
        return this.assigned;
    }

    public TaskSearch setAssigned(Boolean assigned) {
        this.assigned = assigned;
        return this;
    }

    public TaskState getState() {
        return this.state;
    }

    public TaskSearch setState(TaskState state) {
        this.state = state;
        return this;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public TaskSearch setProcessDefinitionKey(String processDefinitionId) {
        this.processDefinitionKey = processDefinitionId;
        return this;
    }

    public String getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    public TaskSearch setProcessInstanceKey(String processInstanceId) {
        this.processInstanceKey = processInstanceId;
        return this;
    }

    public String getTaskDefinitionId() {
        return this.taskDefinitionId;
    }

    public TaskSearch setTaskDefinitionId(String taskDefinitionId) {
        this.taskDefinitionId = taskDefinitionId;
        return this;
    }

    public List<TaskByVariables> getTaskVariables() {
        return this.taskVariables;
    }

    public TaskSearch setTaskVariables(List<TaskByVariables> taskVariables) {
        this.taskVariables = taskVariables;
        return this;
    }

    public TaskSearch addVariableFilter(String variableName, Object variableValue) throws TaskListException {
        return this.addVariableFilter(new TaskByVariables().name(variableName).value(JsonUtils.toJsonString(variableValue)).operator(TaskByVariables.OperatorEnum.EQ));
    }

    public TaskSearch addVariableFilter(TaskByVariables variableFilter) {
        if (this.taskVariables == null) {
            this.taskVariables = new ArrayList<TaskByVariables>();
        }
        this.taskVariables.add(variableFilter);
        return this;
    }

    public List<String> getTenantIds() {
        return this.tenantIds;
    }

    public TaskSearch setTenantIds(List<String> tenantIds) {
        this.tenantIds = tenantIds;
        return this;
    }

    public TaskSearch addTenantId(String tenantId) {
        if (this.tenantIds == null) {
            this.tenantIds = new ArrayList<String>();
        }
        this.tenantIds.add(tenantId);
        return this;
    }

    public Boolean getWithVariables() {
        return this.withVariables;
    }

    public boolean isWithVariables() {
        return this.withVariables != null && this.withVariables != false;
    }

    public TaskSearch setWithVariables(boolean withVariables) {
        this.withVariables = withVariables;
        return this;
    }

    public List<String> getIncludeVariables() {
        return this.includeVariables;
    }

    public TaskSearch setIncludeVariables(List<String> includeVariables) {
        this.includeVariables = includeVariables;
        return this;
    }

    public TaskSearch fetchVariable(String variableName) {
        if (this.includeVariables == null) {
            this.includeVariables = new ArrayList<String>();
        }
        this.includeVariables.add(variableName);
        return this;
    }

    public List<IncludeVariable> getIncludeVariablesAsObj() {
        ArrayList<IncludeVariable> result = new ArrayList<IncludeVariable>();
        if (this.includeVariables != null) {
            for (String var : this.includeVariables) {
                result.add(new IncludeVariable().name(var));
            }
        }
        return result;
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    public TaskSearch setPagination(Pagination pagination) {
        this.pagination = pagination;
        return this;
    }
}

